/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.accounts.analytics;

import com.atlassian.crowd.common.properties.BooleanSystemProperty;
import com.atlassian.crowd.service.accounts.analytics.ServiceAccountEventFactory;
import com.atlassian.crowd.service.accounts.rest.ServiceAccountRestService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class PeriodicAnalyticsService
implements JobRunner,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicAnalyticsService.class);
    private final EventPublisher eventPublisher;
    private final SchedulerService schedulerService;
    private final ServiceAccountRestService serviceAccountRestService;
    private final ServiceAccountEventFactory serviceAccountEventFactory;
    private static final String COLLECTION_SCHEDULE = "0 0 23 * * ?";
    private static final JobId JOB_ID = JobId.of((String)"sa-analytics-periodic-collection-job");
    private static final BooleanSystemProperty CROWD_ANALYTICS_ENABLED = new BooleanSystemProperty("embedded.crowd.analytics.enabled", true);

    @Inject
    public PeriodicAnalyticsService(@Nonnull EventPublisher eventPublisher, @Nonnull SchedulerService schedulerService, @Nonnull ServiceAccountRestService serviceAccountRestService, @Nonnull ServiceAccountEventFactory serviceAccountEventFactory) {
        this.eventPublisher = eventPublisher;
        this.schedulerService = schedulerService;
        this.serviceAccountRestService = serviceAccountRestService;
        this.serviceAccountEventFactory = serviceAccountEventFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (((Boolean)CROWD_ANALYTICS_ENABLED.getValue()).booleanValue()) {
            this.registerScheduledJob();
        }
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        LOG.debug("Collecting active service accounts count...");
        int count = this.serviceAccountRestService.getAllActiveServiceAccountsCount();
        this.eventPublisher.publish((Object)this.serviceAccountEventFactory.createGetAllActiveEvent(count));
        return JobRunnerResponse.success();
    }

    public void destroy() throws Exception {
        this.schedulerService.unregisterJobRunner(this.getJobRunnerKey());
        LOG.debug("Unregistered analytics collection job");
    }

    private void registerScheduledJob() {
        try {
            Class.forName("com.atlassian.analytics.api.annotations.EventName");
        }
        catch (ClassNotFoundException e) {
            LOG.debug("No analytics api, not registering analytics collection");
            return;
        }
        try {
            this.schedulerService.registerJobRunner(this.getJobRunnerKey(), (JobRunner)this);
            this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)this.getJobRunnerKey()).withSchedule(Schedule.forCronExpression((String)COLLECTION_SCHEDULE)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER));
            LOG.debug("Registered analytics collection job with schedule {}", (Object)COLLECTION_SCHEDULE);
        }
        catch (Exception ex) {
            LOG.warn("Failed to register analytics collection job", (Throwable)ex);
        }
    }

    private JobRunnerKey getJobRunnerKey() {
        return JobRunnerKey.of((String)this.getClass().getCanonicalName());
    }
}

