/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.accounts.data;

import com.atlassian.crowd.service.accounts.data.OauthExpiryOption;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;

public class ServiceAccountsData {
    private final String serverTimeZone;
    private final String userTimeZone;
    private final String userLocale;
    private final Collection<OauthExpiryOption> oauth2ExpiryOptions;
    private final Integer defaultOauth2Expiry;
    private final int displayNameMinLength;
    private final int displayNameMaxLength;
    private final int descriptionMaxLength;

    public ServiceAccountsData(@Nonnull String serverTimeZone, @Nonnull String userTimeZone, @Nonnull String userLocale, @Nonnull Collection<OauthExpiryOption> oauth2ExpiryOptions, @Nonnull Integer defaultOauth2Expiry, int displayNameMinLength, int displayNameMaxLength, int descriptionMaxLength) {
        this.serverTimeZone = Objects.requireNonNull(serverTimeZone);
        this.userTimeZone = Objects.requireNonNull(userTimeZone);
        this.userLocale = Objects.requireNonNull(userLocale);
        this.oauth2ExpiryOptions = Objects.requireNonNull(oauth2ExpiryOptions);
        this.defaultOauth2Expiry = Objects.requireNonNull(defaultOauth2Expiry);
        this.displayNameMinLength = displayNameMinLength;
        this.displayNameMaxLength = displayNameMaxLength;
        this.descriptionMaxLength = descriptionMaxLength;
    }

    @Nonnull
    public String getUserTimeZone() {
        return this.userTimeZone;
    }

    @Nonnull
    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    @Nonnull
    public String getUserLocale() {
        return this.userLocale;
    }

    @Nonnull
    public Collection<OauthExpiryOption> getOauth2ExpiryOptions() {
        return this.oauth2ExpiryOptions;
    }

    @Nonnull
    public Integer getDefaultOauth2Expiry() {
        return this.defaultOauth2Expiry;
    }

    public int getDisplayNameMinLength() {
        return this.displayNameMinLength;
    }

    public int getDisplayNameMaxLength() {
        return this.displayNameMaxLength;
    }

    public int getDescriptionMaxLength() {
        return this.descriptionMaxLength;
    }

    public String toString() {
        return "ServiceAccountsData{serverTimeZone='" + this.serverTimeZone + "', userTimeZone='" + this.userTimeZone + "', userLocale='" + this.userLocale + "', oauth2ExpiryOptions=" + String.valueOf(this.oauth2ExpiryOptions) + "', defaultOauth2Expiry=" + this.defaultOauth2Expiry + ", displayNameMinLength=" + this.displayNameMinLength + ", displayNameMaxLength=" + this.displayNameMaxLength + ", descriptionMaxLength=" + this.descriptionMaxLength + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceAccountsData)) {
            return false;
        }
        ServiceAccountsData that = (ServiceAccountsData)o;
        return com.google.common.base.Objects.equal((Object)this.serverTimeZone, (Object)that.serverTimeZone) && com.google.common.base.Objects.equal((Object)this.userTimeZone, (Object)that.userTimeZone) && com.google.common.base.Objects.equal((Object)this.userLocale, (Object)that.userLocale) && com.google.common.base.Objects.equal(this.oauth2ExpiryOptions, that.oauth2ExpiryOptions) && com.google.common.base.Objects.equal((Object)this.defaultOauth2Expiry, (Object)that.defaultOauth2Expiry) && this.displayNameMinLength == that.displayNameMinLength && this.displayNameMaxLength == that.displayNameMaxLength && this.descriptionMaxLength == that.descriptionMaxLength;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.serverTimeZone, this.userTimeZone, this.userLocale, this.oauth2ExpiryOptions, this.defaultOauth2Expiry, this.displayNameMinLength, this.displayNameMaxLength, this.descriptionMaxLength});
    }
}

