/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.accounts.data;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.crowd.service.accounts.data.OauthExpiryOption;
import com.atlassian.crowd.service.accounts.data.ServiceAccountsData;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ServiceAccountsDataProvider
implements WebResourceDataProvider {
    private static final String PROP_FILE_PATH = "/atlassian-sa-fe-config.properties";
    private static final String OAUTH2_EXPIRY_OPTIONS_LABELS_KEY = "crowd.service.accounts.steps.details.expiry.options.label";
    private static final String OAUTH2_EXPIRY_OPTIONS_VALUES_KEY = "atlassian.sa.frontend.oauth2.expiry.options.values";
    private static final String OAUTH2_EXPIRY_OPTIONS_DEFAULT_KEY = "atlassian.sa.frontend.oauth2.expiry.options.default";
    private static final String SPLIT = ",";
    private static final Integer MONTH_IN_SECONDS = 2628000;
    private final TimeZoneManager timeZoneManager;
    private final LocaleResolver localeResolver;
    private final ObjectMapper objectMapper;
    private final Properties frontendConfig;
    private final I18nResolver i18nResolver;

    public ServiceAccountsDataProvider(ObjectMapper objectMapper, TimeZoneManager timeZoneManager, LocaleResolver localeResolver, I18nResolver i18nResolver) {
        this(objectMapper, timeZoneManager, localeResolver, i18nResolver, () -> {
            Properties properties = new Properties();
            try {
                properties.load(ServiceAccountsDataProvider.class.getResourceAsStream(PROP_FILE_PATH));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return properties;
        });
    }

    @VisibleForTesting
    ServiceAccountsDataProvider(ObjectMapper objectMapper, TimeZoneManager timeZoneManager, LocaleResolver localeResolver, I18nResolver i18nResolver, Supplier<Properties> properties) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.timeZoneManager = Objects.requireNonNull(timeZoneManager);
        this.localeResolver = Objects.requireNonNull(localeResolver);
        this.i18nResolver = Objects.requireNonNull(i18nResolver);
        this.frontendConfig = properties.get();
    }

    public Jsonable get() {
        return writer -> {
            try {
                this.objectMapper.writeValue(writer, (Object)this.getData());
            }
            catch (Exception e) {
                throw new JsonMappingException(e.getMessage(), (Throwable)e);
            }
        };
    }

    @VisibleForTesting
    ServiceAccountsData getData() {
        return new ServiceAccountsData(this.getServerTimeZone(), this.getUserTimeZone(), this.getUserLocale(), this.getOauth2ExpiryOptions(), this.getDefaultOauth2ExpiryValue(), 6, 100, 255);
    }

    private String getServerTimeZone() {
        return this.timeZoneManager.getDefaultTimeZone().getID();
    }

    private String getUserLocale() {
        return this.localeResolver.getLocale().toLanguageTag();
    }

    private String getUserTimeZone() {
        return this.timeZoneManager.getUserTimeZone().getID();
    }

    public Collection<OauthExpiryOption> getOauth2ExpiryOptions() {
        List values = Arrays.stream(this.frontendConfig.getProperty(OAUTH2_EXPIRY_OPTIONS_VALUES_KEY, "").split(SPLIT)).mapToInt(Integer::parseInt).filter(value -> value > 0).boxed().collect(Collectors.toList());
        return IntStream.range(0, values.size()).mapToObj(index -> new OauthExpiryOption((Integer)values.get(index) * MONTH_IN_SECONDS, this.i18nResolver.getText(OAUTH2_EXPIRY_OPTIONS_LABELS_KEY + (index + 1)))).collect(Collectors.toList());
    }

    public Integer getDefaultOauth2ExpiryValue() {
        String defaultValue = this.frontendConfig.getProperty(OAUTH2_EXPIRY_OPTIONS_DEFAULT_KEY, "3");
        return Integer.parseInt(defaultValue) * MONTH_IN_SECONDS;
    }
}

