/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.accounts.rest;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.crowd.service.accounts.analytics.ServiceAccountEventFactory;
import com.atlassian.crowd.service.accounts.rest.ServiceAccountException;
import com.atlassian.crowd.service.accounts.rest.ServiceAccountNotFoundException;
import com.atlassian.crowd.service.accounts.rest.ServiceAccountRestService;
import com.atlassian.crowd.service.accounts.rest.entities.PageDto;
import com.atlassian.crowd.service.accounts.rest.entities.ServiceAccountCreateDto;
import com.atlassian.crowd.service.accounts.rest.entities.ServiceAccountDto;
import com.atlassian.crowd.service.accounts.rest.entities.ServiceAccountUpdateDto;
import com.atlassian.crowd.service.accounts.rest.entities.ServiceAccountValidator;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/service-accounts")
@Produces(value={"application/json"})
@SystemAdminOnly
@ExperimentalApi
public class ServiceAccountResource {
    private static final Logger logger = LoggerFactory.getLogger(ServiceAccountResource.class);
    private final ServiceAccountRestService serviceAccountRestService;
    private final EventPublisher eventPublisher;
    private final ServiceAccountEventFactory serviceAccountEventFactory;
    private final ServiceAccountValidator serviceAccountValidator;

    @Inject
    public ServiceAccountResource(ServiceAccountRestService serviceAccountRestService, EventPublisher eventPublisher, ServiceAccountEventFactory serviceAccountEventFactory, ServiceAccountValidator serviceAccountValidator) {
        this.serviceAccountRestService = serviceAccountRestService;
        this.eventPublisher = eventPublisher;
        this.serviceAccountEventFactory = serviceAccountEventFactory;
        this.serviceAccountValidator = serviceAccountValidator;
    }

    @GET
    public PageDto<ServiceAccountDto> search(@QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @QueryParam(value="active") @DefaultValue(value="true") Boolean active, @QueryParam(value="name") @DefaultValue(value="") String name) {
        logger.debug("Getting service accounts (active={}, name='{}') with start {} and limit {}", new Object[]{active, name, start, limit});
        return this.serviceAccountRestService.getServiceAccounts(start, limit, active, name);
    }

    @POST
    public Response create(@Valid ServiceAccountCreateDto dto) {
        logger.debug("Creating service account with {}", (Object)dto);
        this.serviceAccountValidator.validateCreate(dto);
        ServiceAccountDto created = this.serviceAccountRestService.createServiceAccount(dto);
        logger.info("Created service account {}", (Object)created);
        this.eventPublisher.publish((Object)this.serviceAccountEventFactory.createCreateEvent());
        return Response.ok((Object)created).build();
    }

    @PUT
    @Path(value="/{id}")
    public Response update(@PathParam(value="id") String id, ServiceAccountUpdateDto dto) {
        logger.debug("Updating service account with id {} and {}", (Object)id, (Object)dto);
        this.serviceAccountValidator.validateUpdate(dto);
        try {
            ServiceAccountDto updatedServiceAccount = this.serviceAccountRestService.updateServiceAccount(Long.parseLong(id), dto);
            logger.info("Updated service account {} with {}", (Object)id, (Object)updatedServiceAccount);
            return Response.ok((Object)updatedServiceAccount).build();
        }
        catch (ServiceAccountNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response archive(@PathParam(value="id") String id) {
        logger.debug("Archiving service account with id {}", (Object)id);
        try {
            ServiceAccountDto archived = this.serviceAccountRestService.archiveServiceAccount(Long.parseLong(id));
            return Response.ok((Object)archived).build();
        }
        catch (ServiceAccountException e) {
            logger.warn("Unable to archive serviceAccount with id {}", (Object)id);
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
    }

    @GET
    @Path(value="/{id}")
    public Response get(@PathParam(value="id") String id) {
        logger.debug("Getting service account with id {}", (Object)id);
        try {
            ServiceAccountDto serviceAccount = this.serviceAccountRestService.getServiceAccount(Long.parseLong(id));
            this.eventPublisher.publish((Object)this.serviceAccountEventFactory.createGetEvent());
            return Response.ok((Object)serviceAccount).build();
        }
        catch (ServiceAccountNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

