/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.accounts.rest;

import com.atlassian.crowd.embedded.api.OAuth2Method;
import com.atlassian.crowd.embedded.api.Page;
import com.atlassian.crowd.embedded.api.PageRequest;
import com.atlassian.crowd.embedded.api.authentication.AuthMethod;
import com.atlassian.crowd.embedded.api.service.ServiceAccount;
import com.atlassian.crowd.embedded.api.service.ServiceAccountAuthMethod;
import com.atlassian.crowd.embedded.api.service.ServiceAccountAuthService;
import com.atlassian.crowd.embedded.api.service.ServiceAccountManager;
import com.atlassian.crowd.embedded.api.service.ServiceAccountQuery;
import com.atlassian.crowd.embedded.spi.service.RestrictedResourcesProvider;
import com.atlassian.crowd.manager.service.ServiceAccountQueryImpl;
import com.atlassian.crowd.model.service.ServiceAccountAuthMethodImpl;
import com.atlassian.crowd.search.PageRequestImpl;
import com.atlassian.crowd.service.accounts.rest.ServiceAccountException;
import com.atlassian.crowd.service.accounts.rest.ServiceAccountNotFoundException;
import com.atlassian.crowd.service.accounts.rest.entities.AuthorDto;
import com.atlassian.crowd.service.accounts.rest.entities.OAuth2AuthMethodDto;
import com.atlassian.crowd.service.accounts.rest.entities.PageDto;
import com.atlassian.crowd.service.accounts.rest.entities.ResourceDto;
import com.atlassian.crowd.service.accounts.rest.entities.ServiceAccountCreateDto;
import com.atlassian.crowd.service.accounts.rest.entities.ServiceAccountDto;
import com.atlassian.crowd.service.accounts.rest.entities.ServiceAccountUpdateDto;
import com.atlassian.crowd.service.accounts.rest.mappers.ServiceAccountMapper;
import com.atlassian.oauth2.client.api.storage.config.GrantType;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.client.ClientExpirationEvaluator;
import com.atlassian.oauth2.provider.api.client.ClientService;
import com.atlassian.oauth2.provider.api.client.CreateClientEntity;
import com.atlassian.oauth2.provider.api.external.OAuth2ProviderService;
import com.atlassian.oauth2.scopes.api.Scope;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceAccountRestService {
    private static final Logger log = LoggerFactory.getLogger(ServiceAccountRestService.class);
    private static final String SOON_TO_EXPIRE_PROPERTY_KEY = "crowd.admin.client.credentials.soon.to.expire.in.days";
    private static final int DEFAULT_SOON_TO_EXPIRE_IN_DAYS = 14;
    private static final Duration DEFAULT_CLIENT_CREDENTIALS_LIFETIME = Duration.ofDays(90L);
    private static final ServiceAccountQuery GET_ALL_QUERY = new ServiceAccountQueryImpl(Boolean.valueOf(true), "");
    private static final PageRequest GET_ALL_REQUEST = new PageRequestImpl(0, 1000);
    private final ClientService clientService;
    private final ScopeResolver scopeResolver;
    private final ServiceAccountManager serviceAccountManager;
    private final ServiceAccountAuthService serviceAccountAuthService;
    private final RestrictedResourcesProvider restrictedResourcesProvider;
    private final ClientExpirationEvaluator clientExpirationEvaluator;
    private final OAuth2ProviderService oAuth2ProviderService;
    private final UserManager userManager;

    public ServiceAccountRestService(ClientService clientService, ScopeResolver scopeResolver, ServiceAccountManager serviceAccountManager, ServiceAccountAuthService serviceAccountAuthService, RestrictedResourcesProvider restrictedResourcesProvider, ClientExpirationEvaluator clientExpirationEvaluator, OAuth2ProviderService oAuth2ProviderService, UserManager userManager) {
        this.clientService = clientService;
        this.scopeResolver = scopeResolver;
        this.serviceAccountManager = serviceAccountManager;
        this.serviceAccountAuthService = serviceAccountAuthService;
        this.restrictedResourcesProvider = restrictedResourcesProvider;
        this.clientExpirationEvaluator = clientExpirationEvaluator;
        this.oAuth2ProviderService = oAuth2ProviderService;
        this.userManager = userManager;
    }

    public ServiceAccountDto createServiceAccount(ServiceAccountCreateDto dto) {
        log.debug("Creating service account with display name: {}", (Object)dto.displayName());
        ServiceAccount newServiceAccount = ServiceAccountMapper.toServiceAccount(dto, this.restrictedResourcesProvider);
        ServiceAccount createdServiceAccount = this.serviceAccountManager.createServiceAccount(newServiceAccount);
        if (createdServiceAccount == null) {
            throw new ServiceAccountException("Failed to create service account: " + dto.displayName());
        }
        log.debug("Service account created with ID: {}", (Object)createdServiceAccount.getId());
        String clientName = createdServiceAccount.getName();
        Scope scopes = this.scopeResolver.getScope(String.join((CharSequence)" ", dto.scopes()));
        Long expiryDuration = dto.expiryDuration();
        log.debug("Adding client for service account with name: {}, scopes: {}, expiry duration: {}", new Object[]{clientName, scopes, expiryDuration});
        Client client = this.clientService.create(new CreateClientEntity(clientName, scopes, Collections.emptyList(), Set.of(GrantType.CLIENT_CREDENTIALS_GRANT), expiryDuration != null ? Duration.ofSeconds(expiryDuration) : DEFAULT_CLIENT_CREDENTIALS_LIFETIME));
        log.debug("Client created with ID: {}", (Object)client.getId());
        log.debug("Associating service account ID: {} with client ID: {}", (Object)createdServiceAccount.getId(), (Object)client.getId());
        ServiceAccountAuthMethodImpl authMethod = new ServiceAccountAuthMethodImpl(client.getId(), (AuthMethod)new OAuth2Method());
        this.serviceAccountAuthService.updateAuth(createdServiceAccount, (ServiceAccountAuthMethod)authMethod);
        log.debug("Service account ID: {} associated with client ID: {}", (Object)createdServiceAccount.getId(), (Object)client.getId());
        return ServiceAccountRestService.getServiceAccountDto(createdServiceAccount, List.of(this.getOAuth2AuthMethodDto(client, true)));
    }

    private static ServiceAccountDto getServiceAccountDto(ServiceAccount serviceAccount, List<OAuth2AuthMethodDto> authMethods) {
        return new ServiceAccountDto(serviceAccount.getId(), serviceAccount.isActive(), serviceAccount.getName(), serviceAccount.getDisplayName(), serviceAccount.getDescription(), serviceAccount.getResourceRestrictions().values().stream().flatMap(Collection::stream).map(resource -> new ResourceDto(resource.getId(), resource.getTypeId(), null)).toList(), authMethods);
    }

    private OAuth2AuthMethodDto getOAuth2AuthMethodDto(Client client, boolean displayClientSecret) {
        Instant clientCreatedAt = Instant.ofEpochMilli(client.getCreatedDate());
        Instant lastAccessedAtForOAuth2Client = this.getLastAccessedAtForOAuth2Client(client.getClientId());
        UserProfile userProfile = this.userManager.getUserProfile(new UserKey(client.getUserKey()));
        return new OAuth2AuthMethodDto("OAuth2", client.getId(), client.getClientId(), displayClientSecret ? client.getClientSecret() : null, client.getRotatedClientId(), lastAccessedAtForOAuth2Client != null ? lastAccessedAtForOAuth2Client.toString() : null, clientCreatedAt.toString(), client.getExpiryDuration() != null ? Long.valueOf(client.getExpiryDuration().toSeconds()) : null, clientCreatedAt.plusSeconds(client.getExpiryDuration() != null ? client.getExpiryDuration().toSeconds() : DEFAULT_CLIENT_CREDENTIALS_LIFETIME.toSeconds()).toString(), this.clientExpirationEvaluator.hasSoonToExpireLimitBreached(client, this.getSoonToExpireThreshold()), new AuthorDto(userProfile.getFullName(), userProfile.getEmail()), Set.of(client.getScope().getName().split(" ")));
    }

    public ServiceAccountDto updateServiceAccount(Long id, ServiceAccountUpdateDto dto) {
        log.debug("Updating service account with ID: {}", (Object)id);
        ServiceAccount existingServiceAccount = (ServiceAccount)this.serviceAccountManager.getServiceAccount(id.longValue()).orElseThrow(() -> new ServiceAccountNotFoundException("Service account with id " + id + " not found"));
        ServiceAccount serviceAccountUpdate = ServiceAccountMapper.toServiceAccount(dto, existingServiceAccount, this.restrictedResourcesProvider);
        boolean updated = this.serviceAccountManager.updateServiceAccount(serviceAccountUpdate);
        if (!updated) {
            throw new ServiceAccountException("Failed to update service account with id: " + id);
        }
        log.debug("Service account with ID: {} updated successfully", (Object)id);
        ServiceAccount updatedServiceAccount = (ServiceAccount)this.serviceAccountManager.getServiceAccount(id.longValue()).orElseThrow(() -> new ServiceAccountNotFoundException("Service account with id " + id + " not found after update"));
        List<OAuth2AuthMethodDto> authMethods = this.getAuthMethodsByServiceAccountId(id);
        return ServiceAccountRestService.getServiceAccountDto(updatedServiceAccount, authMethods);
    }

    private List<OAuth2AuthMethodDto> getAuthMethodsByServiceAccountId(Long id) {
        return this.serviceAccountAuthService.getAuthMethods(id.longValue()).stream().filter(authMethod -> authMethod.getAuthType() instanceof OAuth2Method).map(authMethod -> this.clientService.getById(authMethod.getAuthId())).filter(Optional::isPresent).map(client -> this.getOAuth2AuthMethodDto((Client)client.get(), false)).toList();
    }

    public ServiceAccountDto getServiceAccount(Long id) {
        log.debug("Retrieving service account with ID: {}", (Object)id);
        ServiceAccount serviceAccount = (ServiceAccount)this.serviceAccountManager.getServiceAccount(id.longValue()).orElseThrow(() -> new ServiceAccountNotFoundException("Service account with id " + id + " not found"));
        List<OAuth2AuthMethodDto> authMethods = this.getAuthMethodsByServiceAccountId(id);
        log.debug("Service account with ID: {} retrieved successfully", (Object)id);
        return ServiceAccountRestService.getServiceAccountDto(serviceAccount, authMethods);
    }

    public PageDto<ServiceAccountDto> getServiceAccounts(int start, int limit, boolean active, String name) {
        log.debug("Retrieving service accounts (active={}, name='{}') with start {} and limit {}", new Object[]{active, name, start, limit});
        ServiceAccountQueryImpl query = new ServiceAccountQueryImpl(Boolean.valueOf(active), name);
        PageRequestImpl request = new PageRequestImpl(start, limit);
        Page page = this.serviceAccountManager.findServiceAccounts((ServiceAccountQuery)query, (PageRequest)request);
        if (page.results().isEmpty()) {
            log.debug("No service accounts found");
            return new PageDto<ServiceAccountDto>(page.start(), page.limit(), page.isLastPage(), Collections.emptyList());
        }
        log.debug("Converting {} service accounts to DTOs", (Object)page.results().size());
        List<ServiceAccountDto> serviceAccountDtos = page.results().stream().map(serviceAccount -> ServiceAccountRestService.getServiceAccountDto(serviceAccount, this.getAuthMethodsByServiceAccountId(serviceAccount.getId()))).toList();
        return new PageDto<ServiceAccountDto>(page.start(), page.limit(), page.isLastPage(), serviceAccountDtos);
    }

    public int getAllActiveServiceAccountsCount() {
        log.debug("Retrieving all active service accounts");
        Page page = this.serviceAccountManager.findServiceAccounts(GET_ALL_QUERY, GET_ALL_REQUEST);
        int size = page.size();
        while (!page.isLastPage()) {
            log.debug("Continuing to retrieve service accounts, current size: {}", (Object)size);
            page = this.serviceAccountManager.findServiceAccounts(GET_ALL_QUERY, (PageRequest)new PageRequestImpl(page.start() + size, GET_ALL_REQUEST.limit()));
            log.debug("Retrieved additional service accounts, new size: {}", (Object)(size += page.size()));
        }
        return size;
    }

    public ServiceAccountDto archiveServiceAccount(Long id) {
        log.debug("Archiving service account with ID: {}", (Object)id);
        ServiceAccount serviceAccount = (ServiceAccount)this.serviceAccountManager.getServiceAccount(id.longValue()).orElseThrow(() -> new ServiceAccountNotFoundException("Service account with id " + id + " not found"));
        this.serviceAccountAuthService.getAuthMethods(id.longValue()).forEach(authMethod -> {
            log.debug("Deleting auth method with ID: {}", (Object)authMethod.getAuthId());
            this.clientService.removeById(authMethod.getAuthId());
            this.serviceAccountAuthService.deleteAuth(serviceAccount, authMethod);
            log.debug("Auth method with ID: {} deleted successfully", (Object)authMethod.getAuthId());
        });
        if (!this.serviceAccountManager.archiveServiceAccount(id.longValue())) {
            throw new ServiceAccountException("Failed to archive service account with id: " + id);
        }
        log.debug("Service account with ID: {} archived successfully", (Object)id);
        ServiceAccount archivedServiceAccount = (ServiceAccount)this.serviceAccountManager.getServiceAccount(id.longValue()).orElseThrow(() -> new ServiceAccountNotFoundException("Service account with id " + id + " not found after archiving"));
        return ServiceAccountRestService.getServiceAccountDto(archivedServiceAccount, Collections.emptyList());
    }

    private Duration getSoonToExpireThreshold() {
        String soonToExpireProp = System.getProperty(SOON_TO_EXPIRE_PROPERTY_KEY);
        try {
            int soonToExpireInDays = soonToExpireProp != null ? Integer.parseInt(soonToExpireProp) : 14;
            return Duration.ofDays(soonToExpireInDays);
        }
        catch (NumberFormatException e) {
            log.error("Invalid number format for '{}': {}", (Object)SOON_TO_EXPIRE_PROPERTY_KEY, (Object)soonToExpireProp);
            return Duration.ofDays(14L);
        }
    }

    private Map<String, Instant> getLastAccessedAtForClients(Collection<String> oauth2ClientIds) {
        return this.oAuth2ProviderService.findLastAccessedDatesForClients(oauth2ClientIds);
    }

    private Instant getLastAccessedAtForOAuth2Client(String clientId) {
        return (Instant)this.oAuth2ProviderService.findLastAccessedDatesForClients(Collections.singletonList(clientId)).get(clientId);
    }
}

