/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.accounts.rest.entities;

import com.atlassian.crowd.service.accounts.rest.ServiceAccountValidationException;
import com.atlassian.crowd.service.accounts.rest.entities.ServiceAccountCreateDto;
import com.atlassian.crowd.service.accounts.rest.entities.ServiceAccountUpdateDto;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.util.Set;

public class ServiceAccountValidator {
    public static final String DISPLAY_NAME_CANNOT_BE_EMPTY_KEY = "crowd.service.accounts.validation.display.name.cannot.be.empty";
    public static final String DISPLAY_NAME_LENGTH_INVALID_KEY = "crowd.service.accounts.validation.display.name.length.invalid";
    public static final String DESCRIPTION_TOO_LONG_KEY = "crowd.service.accounts.validation.description.too.long";
    public static final String SCOPES_REQUIRED_KEY = "crowd.service.accounts.validation.scopes.required";
    private final I18nResolver i18nResolver;

    public ServiceAccountValidator(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public void validateCreate(ServiceAccountCreateDto serviceAccount) {
        this.validateDisplayName(serviceAccount.displayName());
        this.validateDescription(serviceAccount.description());
        this.validateScopes(serviceAccount.scopes());
    }

    public void validateUpdate(ServiceAccountUpdateDto serviceAccount) {
        this.validateDisplayName(serviceAccount.getDisplayName());
        this.validateDescription(serviceAccount.getDescription());
    }

    private void validateDisplayName(String displayName) {
        if (displayName == null) {
            throw new ServiceAccountValidationException(this.i18nResolver.getText(DISPLAY_NAME_CANNOT_BE_EMPTY_KEY, new Serializable[]{Integer.valueOf(6), Integer.valueOf(100)}));
        }
        if (displayName.length() < 6 || displayName.length() > 100) {
            throw new ServiceAccountValidationException(this.i18nResolver.getText(DISPLAY_NAME_LENGTH_INVALID_KEY, new Serializable[]{Integer.valueOf(6), Integer.valueOf(100)}));
        }
    }

    private void validateDescription(String description) {
        if (description != null && description.length() > 255) {
            throw new ServiceAccountValidationException(this.i18nResolver.getText(DESCRIPTION_TOO_LONG_KEY, new Serializable[]{Integer.valueOf(255)}));
        }
    }

    private void validateScopes(Set<String> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            throw new ServiceAccountValidationException(this.i18nResolver.getText(SCOPES_REQUIRED_KEY));
        }
    }
}

