/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.accounts.rest.mappers;

import com.atlassian.crowd.embedded.spi.service.ResourceDescription;
import com.atlassian.crowd.embedded.spi.service.ResourceTypeDescription;
import com.atlassian.crowd.service.accounts.rest.entities.ResourceDto;
import com.atlassian.crowd.service.accounts.rest.entities.ResourceTypeDto;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Collection;
import java.util.List;

public final class ResourceMapper {
    private ResourceMapper() {
    }

    public static List<ResourceDto> toResourceDtos(Collection<? extends ResourceDescription> resourceDescriptions) {
        return resourceDescriptions.stream().map(resource -> new ResourceDto(resource.getResource().getId(), resource.getResource().getTypeId(), resource.getDescription())).toList();
    }

    public static ResourceTypeDto toResourceTypeDto(ResourceTypeDescription resourceTypeDescription, I18nResolver i18nResolver) {
        String i18nKey = resourceTypeDescription.getNameI18nKey();
        String description = i18nResolver.getText(i18nKey);
        return new ResourceTypeDto(resourceTypeDescription.getResourceType().getId(), description);
    }
}

