/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.accounts.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.permission.AuthorisationException;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class ServiceAccountsServlet
extends HttpServlet {
    static final String RESOURCE_KEY = "com.atlassian.crowd.service-accounts-plugin:sa-base-resources";
    static final String TEMPLATE_KEY = "crowd.service.accounts.templates.admin";
    private static final String URL = "/plugins/servlet/service-accounts";
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final LoginUriProvider loginUriProvider;
    private final WebSudoManager webSudoManager;
    private final PermissionEnforcer permissionEnforcer;

    @Inject
    public ServiceAccountsServlet(SoyTemplateRenderer soyTemplateRenderer, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager, PermissionEnforcer permissionEnforcer) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.loginUriProvider = loginUriProvider;
        this.webSudoManager = webSudoManager;
        this.permissionEnforcer = permissionEnforcer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            this.permissionEnforcer.enforceSystemAdmin();
            this.renderTemplate(request, response);
        }
        catch (WebSudoSessionException e) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
        catch (AuthorisationException e) {
            this.redirectToLogin(request, response);
        }
    }

    private void renderTemplate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        this.soyTemplateRenderer.render((Appendable)response.getWriter(), RESOURCE_KEY, TEMPLATE_KEY, null);
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MultiValueMap<String, String> parameters = this.toMultiValueMap(request.getParameterMap());
        String target = this.loginUriProvider.getLoginUriForRole(UriComponentsBuilder.fromUriString((String)URL).queryParams(parameters).build().toUri(), UserRole.SYSADMIN).toString();
        response.sendRedirect(target);
    }

    private MultiValueMap<String, String> toMultiValueMap(Map<String, String[]> params) {
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            multiValueMap.put((Object)entry.getKey(), Arrays.asList(entry.getValue()));
        }
        return multiValueMap;
    }
}

