/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.config.internal.lifecycle;

import com.atlassian.config.internal.lifecycle.LifecycleManager;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.spring.container.ContainerManager;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;

public class LifecycleServletContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        if (this.shouldRunLifecycle()) {
            this.getLifecycleManager().startUp(servletContextEvent.getServletContext());
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (this.shouldRunLifecycle()) {
            this.getLifecycleManager().shutDown(servletContextEvent.getServletContext());
        }
    }

    private LifecycleManager getLifecycleManager() {
        return (LifecycleManager)ContainerManager.getComponent((String)"lifecycleManager");
    }

    private boolean shouldRunLifecycle() {
        return ContainerManager.isContainerSetup() && BootstrapUtils.getBootstrapManager().isSetupComplete();
    }
}

