/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.tomcat.utils;

import com.atlassian.secrets.tomcat.cipher.ProductCipher;
import java.io.File;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class DecryptTool {
    private static final Log log = LogFactory.getLog(DecryptTool.class);
    private final String encryptionKeyFile;
    final ProductCipher cipher = new ProductCipher();

    public DecryptTool(String encryptionKeyFile) {
        this.encryptionKeyFile = encryptionKeyFile;
    }

    public void decrypt(Supplier<String> getter, Consumer<String> setter, String propertyName) {
        log.debug((Object)("Setting password: " + propertyName));
        String encryptedPassword = getter.get();
        if (encryptedPassword == null) {
            log.debug((Object)String.format("Encrypted password is null for property %s", propertyName));
            return;
        }
        if (DecryptTool.isFile(encryptedPassword)) {
            String decryptedPassword = this.cipher.decrypt(encryptedPassword, this.encryptionKeyFile);
            setter.accept(decryptedPassword);
            log.debug((Object)("Successfully decrypted and set password: " + propertyName));
        } else {
            log.warn((Object)String.format("Password for %s is not a file path or the file is missing. Attempting to use password as it is", propertyName));
            setter.accept(encryptedPassword);
        }
    }

    private static boolean isFile(String encryptedPasswordFile) {
        File f = new File(encryptedPasswordFile);
        return f.isFile();
    }
}

