/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.support;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.troubleshooting.api.supportzip.FileSupportZipArtifact;
import com.atlassian.troubleshooting.api.supportzip.SupportZipBundle;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.file.SimplePathVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshSidecarSupportZipBundle
implements SupportZipBundle {
    private static final Logger log = LoggerFactory.getLogger(MeshSidecarSupportZipBundle.class);
    private final I18nService i18nService;
    private final DmzMeshService meshService;
    private final StorageService storageService;

    public MeshSidecarSupportZipBundle(I18nService i18nService, DmzMeshService meshService, StorageService storageService) {
        this.i18nService = i18nService;
        this.meshService = meshService;
        this.storageService = storageService;
    }

    public String getApplicabilityReason() {
        return this.i18nService.getMessage("bitbucket.mesh.support.sidecar.applicability-reason", new Object[0]);
    }

    public Collection<SupportZipBundle.Artifact> getArtifacts() {
        MeshNode sidecar = this.meshService.getSidecar().orElse(null);
        if (sidecar == null) {
            return Collections.emptyList();
        }
        Path meshDir = this.storageService.getHomeDir().resolve("mesh");
        final String sidecarId = sidecar.getRpcId();
        final ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new FileSupportZipArtifact(meshDir.resolve("mesh.properties").toFile(), sidecarId));
        builder.add((Object)new FileSupportZipArtifact(meshDir.resolve("mesh-node.properties").toFile(), sidecarId));
        try {
            Files.walkFileTree(meshDir.resolve("log"), (FileVisitor<? super Path>)new SimplePathVisitor(this){

                public FileVisitResult visitFile(Path logFile, BasicFileAttributes attrs) {
                    builder.add((Object)new FileSupportZipArtifact(logFile.toFile(), sidecarId + "/log"));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            log.error("Could not get all the log files for the Mesh sidecar", (Throwable)e);
        }
        return builder.build();
    }

    public String getDescription() {
        return this.i18nService.getMessage("bitbucket.mesh.support.sidecar.description", new Object[0]);
    }

    public String getKey() {
        return "mesh-sidecar";
    }

    public String getTitle() {
        return this.i18nService.getMessage("bitbucket.mesh.support.sidecar.title", new Object[0]);
    }

    public boolean isApplicable() {
        return this.meshService.isEnabled();
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isSelected() {
        return true;
    }
}

