/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting;

import com.atlassian.sal.api.features.DarkFeatureManager;
import java.util.Map;
import java.util.Set;

public class CommonFeatureFlags {
    public static final String LICENSE_LIMIT_HEALTHCHECK_UI_ENABLE_FEATURE_FLAG = "com.atlassian.troubleshooting.healthcheck.license.limit.healthcheck.ui";
    public static final String LICENSE_LIMIT_HEALTHCHECK_CONFIGURABLE_FROM_ATST_FEATURE_FLAG = "com.atlassian.troubleshooting.healthcheck.license.limit.healthcheck.atst-configurable";
    private static final String ENABLED_SUFFIX = ".enabled";
    private static final String DISABLED_SUFFIX = ".disabled";
    public static final Set<String> ALL_FEATURE_FLAGS = Set.of("com.atlassian.troubleshooting.healthcheck.license.limit.healthcheck.ui", "com.atlassian.troubleshooting.healthcheck.license.limit.healthcheck.atst-configurable");
    private static final Map<String, Boolean> DEFAULT_VALUES = Map.of("com.atlassian.troubleshooting.healthcheck.license.limit.healthcheck.ui", true, "com.atlassian.troubleshooting.healthcheck.license.limit.healthcheck.atst-configurable", true);

    private CommonFeatureFlags() {
    }

    public static boolean getDefaultValue(String featureKey) {
        return DEFAULT_VALUES.getOrDefault(featureKey, false);
    }

    public static boolean isFeatureFlagEnabled(DarkFeatureManager darkFeatureManager, String featureKey) {
        Set keys = darkFeatureManager.getFeaturesEnabledForCurrentUser().getFeatureKeySet();
        if (keys.contains(featureKey + DISABLED_SUFFIX)) {
            return false;
        }
        if (keys.contains(featureKey + ENABLED_SUFFIX) || keys.contains(featureKey)) {
            return true;
        }
        return CommonFeatureFlags.getDefaultValue(featureKey);
    }
}

