/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.analytic;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.troubleshooting.analytic.DailyAnalyticsEventSupplier;
import com.atlassian.troubleshooting.stp.scheduler.SchedulerServiceProvider;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DailyAnalyticsJob
implements LifecycleAware,
JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(DailyAnalyticsJob.class);
    private static final String EVERY_DAY_AT_MIDNIGHT_CRON = "0 0 0 ? * * *";
    private static final String TASK_ID = "DailyATSTAnalyticsTask";
    private static final JobId JOB_ID = JobId.of((String)"DailyATSTAnalyticsTask");
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)"DailyATSTAnalyticsTask");
    private final SchedulerServiceProvider schedulerServiceProvider;
    private final EventPublisher eventPublisher;
    private final List<DailyAnalyticsEventSupplier> eventSuppliers;
    private SchedulerService schedulerService;

    @Autowired
    public DailyAnalyticsJob(SchedulerServiceProvider schedulerServiceProvider, EventPublisher eventPublisher, List<DailyAnalyticsEventSupplier> eventSuppliers) {
        this.schedulerServiceProvider = Objects.requireNonNull(schedulerServiceProvider);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.eventSuppliers = Objects.requireNonNull(eventSuppliers);
    }

    public void onStart() {
        this.registerAnalyticsSendingJob();
        this.scheduleAnalyticsSendingJob();
        LOG.debug("ATST Daily analytics sending scheduler registered");
    }

    private void registerAnalyticsSendingJob() {
        this.schedulerService = this.schedulerServiceProvider.getSchedulerService();
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
    }

    private void scheduleAnalyticsSendingJob() {
        try {
            JobConfig jobConfig = this.buildJobConfig();
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
        }
        catch (SchedulerServiceException e) {
            LOG.error("Failed to schedule sending Daily ATST analytics", (Throwable)e);
        }
    }

    private JobConfig buildJobConfig() {
        Schedule schedule = Schedule.forCronExpression((String)EVERY_DAY_AT_MIDNIGHT_CRON);
        return JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(schedule);
    }

    public void onStop() {
        this.schedulerService.unregisterJobRunner(JobRunnerKey.of((String)TASK_ID));
        this.schedulerService.unscheduleJob(JOB_ID);
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        LOG.debug("Daily analytics sending scheduler started job.");
        boolean failed = false;
        for (DailyAnalyticsEventSupplier eventSupplier : this.eventSuppliers) {
            try {
                eventSupplier.getDailyAnalyticEvents().stream().filter(Objects::nonNull).forEach(arg_0 -> ((EventPublisher)this.eventPublisher).publish(arg_0));
            }
            catch (Exception eventSupplierException) {
                LOG.error("Error occurred while sending daily analytics", (Throwable)eventSupplierException);
                failed = true;
            }
        }
        LOG.debug("Daily analytics sending scheduler finished job successfully.");
        if (failed) {
            return JobRunnerResponse.failed((String)"Some analytic events couldn't be sent");
        }
        return JobRunnerResponse.success();
    }
}

