/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.api;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

@ParametersAreNonnullByDefault
public class ClusterNode {
    private final String inetAddress;
    private final String id;
    private final String name;

    public ClusterNode(String id, @Nullable String inetAddress, @Nullable String name) {
        this.id = Objects.requireNonNull(id);
        this.inetAddress = inetAddress;
        this.name = name;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public Optional<String> getInetAddress() {
        return Optional.ofNullable(this.inetAddress);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }
}

