/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.api;

import com.atlassian.troubleshooting.api.ClusterNode;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface ClusterService {
    public Optional<ClusterNode> getCurrentNode();

    public Optional<String> getCurrentNodeId();

    default public boolean isClustered() {
        return this.getCurrentNodeId().isPresent();
    }

    @Nonnull
    default public Set<String> getNodeIds() {
        return this.getNodes().stream().map(ClusterNode::getId).collect(Collectors.toSet());
    }

    @Nonnull
    public Collection<ClusterNode> getNodes();

    default public Optional<Integer> getNodeCount() {
        return this.isClustered() ? Optional.of(this.getNodeIds().size()) : Optional.empty();
    }

    default public Optional<Integer> getActiveNodeCount() {
        return this.getNodeCount();
    }
}

