/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bitbucket;

import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.troubleshooting.bitbucket.zip.AuthenticatedMessage;
import com.atlassian.troubleshooting.bitbucket.zip.MessageAuthenticationService;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ATSTMessageTopic {
    public static final String TOPIC_NAME = "ATST_MESSAGE_TOPIC";
    private static final TopicSettings<AuthenticatedMessage<String>> TOPIC_SETTINGS = new TopicSettings.Builder(AuthenticatedMessage.class).build();
    private final Topic<AuthenticatedMessage<String>> supportTopic;
    private final MessageAuthenticationService messageAuthenticationService;

    @Autowired
    public ATSTMessageTopic(@ComponentImport TopicService topicService, MessageAuthenticationService messageAuthenticationService) {
        this.supportTopic = topicService.getTopic(TOPIC_NAME, TOPIC_SETTINGS);
        this.messageAuthenticationService = Objects.requireNonNull(messageAuthenticationService);
    }

    public void publish(String messageJson) {
        Objects.requireNonNull(messageJson);
        this.supportTopic.publish(this.messageAuthenticationService.wrap(messageJson));
    }

    @Nonnull
    public String subscribe(@Nonnull TopicListener<AuthenticatedMessage<String>> listener) {
        Objects.requireNonNull(listener);
        return this.supportTopic.subscribe(this.messageAuthenticationService.authenticateListener(listener));
    }

    public boolean unsubscribe(@Nonnull String subscriptionId) {
        return this.supportTopic.unsubscribe(subscriptionId);
    }
}

