/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bitbucket;

import com.atlassian.troubleshooting.stp.salext.FileSanitizerPatternManager;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class BitBucketFileSanitizerPatternManager
extends FileSanitizerPatternManager {
    private static final String BITBUCKET_PROPERTIES = "bitbucket.properties";
    private static final String BUCKLER_CONFIG_YAML = "buckler.yml";
    private static final String MESH_NODE_PROPERTIES = "mesh-node.properties";
    private static final String MESH_PROPERTIES = "mesh.properties";

    @Override
    protected void initializeProductSpecificSanitizations() {
        this.addSanitizerPattern(BITBUCKET_PROPERTIES, Pattern.compile("^[#\\s]*jdbc\\.password\\s*.(.*)"), Pattern.compile("^[#\\s]*hazelcast\\.group\\.name\\s*.(.*)"), Pattern.compile("^[#\\s]*hazelcast\\.group\\.password\\s*.(.*)"), Pattern.compile("^[#\\s]*hazelcast\\.network\\.aws\\.secret\\.key\\s*.(.*)"), Pattern.compile("^[#\\s]*plugin\\.bitbucket-filestore-s3\\.access-key\\s*.(.*)"), Pattern.compile("^[#\\s]*plugin\\.bitbucket-filestore-s3\\.secret-key\\s*.(.*)"), Pattern.compile("^[#\\s]*plugin\\.search\\.elasticsearch\\.password\\s*.(.*)"), Pattern.compile("^[#\\s]*plugin\\.search\\.config\\.password\\s*.(.*)"), Pattern.compile("^[#\\s]*setup\\.[^\\s=:]+\\s*.(.*)"), Pattern.compile("^[#\\s]*server\\.ssl\\.key-password\\s*.(.*)"), Pattern.compile("^[#\\s]*server\\.ssl\\.key-store-password\\s*.(.*)"));
        this.addSanitizerPattern(BUCKLER_CONFIG_YAML, Pattern.compile("^[#\\s]*auth\\.basic\\.password\\s*.(.*)"));
        this.addSanitizerPattern(MESH_NODE_PROPERTIES, Pattern.compile("^[#\\s]*authentication\\.token\\s*.(.*)"));
        this.addSanitizerPattern(MESH_PROPERTIES, Pattern.compile("^[#\\s]*authentication\\.token\\s*.(.*)"));
    }

    @Override
    protected Stream<String> productSpecificShAndBatFiles() {
        return Stream.empty();
    }
}

