/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bitbucket;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.troubleshooting.bitbucket.BitBucketFileSanitizerPatternManager;
import com.atlassian.troubleshooting.stp.hercules.HerculesRegexResource;
import com.atlassian.troubleshooting.stp.hercules.ScanItem;
import com.atlassian.troubleshooting.stp.hercules.regex.cacheables.SavedExternalResourceService;
import com.atlassian.troubleshooting.stp.properties.SupportDataAppenderManager;
import com.atlassian.troubleshooting.stp.properties.SupportDataXmlKeyResolver;
import com.atlassian.troubleshooting.stp.request.FileSanitizer;
import com.atlassian.troubleshooting.stp.salext.AbstractSupportApplicationInfo;
import com.atlassian.troubleshooting.stp.salext.ApplicationType;
import com.atlassian.troubleshooting.stp.salext.bundle.SupportZipBundleAccessor;
import com.atlassian.troubleshooting.stp.salext.license.ApplicationLicenseInfo;
import com.atlassian.troubleshooting.stp.salext.license.ProductLicenseInfo;
import com.atlassian.troubleshooting.stp.salext.mail.MailUtility;
import com.atlassian.troubleshooting.stp.salext.output.XmlSupportDataFormatter;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class BitbucketApplicationInfo
extends AbstractSupportApplicationInfo {
    private final LicenseHandler licenseHandler;
    private final LicenseService licenseService;
    private final StorageService storageService;

    @Autowired
    public BitbucketApplicationInfo(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport I18nResolver i18nResolver, @ComponentImport TemplateRenderer renderer, @ComponentImport LicenseHandler licenseHandler, @ComponentImport LicenseService licenseService, @ComponentImport @Qualifier(value="pluginAccessor") PluginAccessor pluginAccessor, @ComponentImport StorageService storageService, SupportDataAppenderManager supportDataAppenderManager, SupportDataXmlKeyResolver supportDataXmlKeyResolver, XmlSupportDataFormatter xmlSupportDataFormatter, MailUtility mailUtility, SavedExternalResourceService savedExternalResourceService, BitBucketFileSanitizerPatternManager bitBucketFileSanitizerPatternManager, SupportZipBundleAccessor supportZipBundleAccessor) {
        super(applicationProperties, i18nResolver, renderer, supportDataAppenderManager, supportDataXmlKeyResolver, xmlSupportDataFormatter, pluginAccessor, mailUtility, savedExternalResourceService, bitBucketFileSanitizerPatternManager, supportZipBundleAccessor);
        this.licenseHandler = licenseHandler;
        this.licenseService = licenseService;
        this.storageService = storageService;
    }

    @Override
    public List<ScanItem> getApplicationLogFilePaths() {
        String logFilePath = String.valueOf(this.storageService.getHomeDir()) + "/log/atlassian-bitbucket.log";
        if (new File(logFilePath).exists()) {
            return Collections.singletonList(ScanItem.createDefaultItem(logFilePath));
        }
        return Collections.emptyList();
    }

    @Override
    public String getApplicationHome() {
        return this.storageService.getHomeDir().toFile().toString();
    }

    @Override
    public String getLocalApplicationHome() {
        return this.storageService.getHomeDir().toFile().toString();
    }

    @Override
    @Nonnull
    public File getTempDirectory() {
        return this.storageService.getTempDir().toFile();
    }

    @Override
    @Nonnull
    public File getExportDirectory() {
        return new File(this.getSharedApplicationHome(), "export");
    }

    public String getSharedApplicationHome() {
        return this.storageService.getSharedHomeDir().toFile().getAbsolutePath();
    }

    @Override
    @Nonnull
    public Optional<String> getInstanceTitle() {
        return Optional.of(this.getApplicationName());
    }

    @Override
    public SisyphusPatternSource getPatternSource() {
        return this.getSourceFromCacheable(HerculesRegexResource.BITBUCKET_HERCULES_REGEX);
    }

    @Override
    public String getApplicationSEN() {
        return this.licenseHandler.getSupportEntitlementNumber();
    }

    @Override
    public String getApplicationServerID() {
        return this.licenseHandler.getServerId();
    }

    @Override
    public String getCreateSupportRequestEmail() {
        return "stash-autosupportrequests@atlassian.com";
    }

    @Override
    public String getMailQueueURL(HttpServletRequest request) {
        return null;
    }

    @Override
    public boolean isMailExceptionAvailable() {
        return false;
    }

    @Override
    public String getMailServerConfigurationURL(HttpServletRequest request) {
        return this.getBaseURL(request) + "/admin/mail-server";
    }

    @Override
    public FileSanitizer getFileSanitizer() {
        return new FileSanitizer(this.getFileSanitizerPatternManager(), EXECUTABLE_EXTENSIONS, this.getTempDirectory());
    }

    @Override
    public String getApplicationLogDir() {
        return this.getApplicationHome() + "/log";
    }

    @Override
    public ApplicationLicenseInfo getLicenseInfo() {
        return new ProductLicenseInfo((ProductLicense)this.licenseService.get());
    }

    @Override
    public String getAdminLicenseUrl() {
        return "/admin/license?edit";
    }

    @Override
    public ApplicationType getApplicationType() {
        return ApplicationType.BITBUCKET;
    }

    @Override
    public Pattern getApplicationRestartPattern() {
        return Pattern.compile("(Starting\\sBitbucket)");
    }
}

