/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bitbucket;

import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.troubleshooting.api.ClusterMessagingProvider;
import com.atlassian.troubleshooting.api.ListenerRegistration;
import com.atlassian.troubleshooting.bitbucket.ATSTMessageTopic;
import com.atlassian.troubleshooting.bitbucket.zip.AuthenticatedMessage;
import com.atlassian.troubleshooting.cluster.JsonSerialiser;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class BitbucketClusterMessagingProvider
implements ClusterMessagingProvider {
    private final ATSTMessageTopic atstMessageTopic;
    private final JsonSerialiser jsonSerialiser;

    @Autowired
    public BitbucketClusterMessagingProvider(ATSTMessageTopic atstMessageTopic, JsonSerialiser jsonSerialiser) {
        this.atstMessageTopic = Objects.requireNonNull(atstMessageTopic);
        this.jsonSerialiser = Objects.requireNonNull(jsonSerialiser);
    }

    @Override
    public void sendMessage(String channel, String message) {
        this.atstMessageTopic.publish(this.jsonSerialiser.toJson(new ATSTClusterMessage(channel, message)));
    }

    @Override
    public ListenerRegistration registerListener(String channel, Consumer<String> listener) {
        String subscriptionId = this.atstMessageTopic.subscribe((TopicListener<AuthenticatedMessage<String>>)((TopicListener)messageEvent -> {
            ATSTClusterMessage message = this.jsonSerialiser.fromJson((String)((AuthenticatedMessage)messageEvent.getMessage()).getMessage(), ATSTClusterMessage.class);
            if (message.getChannel().equals(channel)) {
                listener.accept(message.getMessage());
            }
        }));
        return () -> this.atstMessageTopic.unsubscribe(subscriptionId);
    }

    public static class ATSTClusterMessage {
        private final String channel;
        private final String message;

        @JsonCreator
        public ATSTClusterMessage(@JsonProperty(value="channel") String channel, @JsonProperty(value="message") String message) {
            this.channel = channel;
            this.message = message;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

