/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bitbucket;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.troubleshooting.api.ClusterNode;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BitbucketClusterService
implements com.atlassian.troubleshooting.api.ClusterService {
    private final ClusterService bitbucketClusterService;

    @Autowired
    public BitbucketClusterService(@ComponentImport ClusterService bitbucketClusterService) {
        this.bitbucketClusterService = bitbucketClusterService;
    }

    @Override
    public Optional<ClusterNode> getCurrentNode() {
        return this.ifClustered(() -> this.buildNode(this.bitbucketClusterService.getInformation().getLocalNode()));
    }

    @Override
    public Optional<String> getCurrentNodeId() {
        return this.ifClustered(() -> ((ClusterService)this.bitbucketClusterService).getNodeId());
    }

    @Override
    public boolean isClustered() {
        return this.bitbucketClusterService.isAvailable();
    }

    @Override
    @Nonnull
    public Collection<ClusterNode> getNodes() {
        return this.bitbucketClusterService.getInformation().getNodes().stream().map(this::buildNode).collect(Collectors.toSet());
    }

    private ClusterNode buildNode(com.atlassian.bitbucket.cluster.ClusterNode node) {
        return new ClusterNode(node.getId(), node.getAddress().toString(), node.getName());
    }

    private <T> Optional<T> ifClustered(Supplier<T> supplier) {
        return this.isClustered() ? Optional.of(supplier.get()) : Optional.empty();
    }
}

