/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bitbucket;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.troubleshooting.api.healthcheck.LicenseService;
import com.atlassian.troubleshooting.preupgrade.checks.Expiry;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BitbucketLicenseService
implements LicenseService {
    private final com.atlassian.bitbucket.license.LicenseService licenseService;

    @Autowired
    public BitbucketLicenseService(@ComponentImport com.atlassian.bitbucket.license.LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    @Override
    public boolean isEvaluation() {
        return this.licenseService.get() != null && this.licenseService.get().isEvaluation();
    }

    @Override
    public boolean userCanRequestTechnicalSupport() {
        return !LicenseService.isStarterLicense((ProductLicense)this.licenseService.get(), Product.BITBUCKET_SERVER.getNamespace());
    }

    @Override
    public boolean isWithinMaintenanceFor(Date date) {
        BitbucketServerLicense license = this.licenseService.get();
        return this.isEnterprise(license) || Expiry.fromDate(license.getMaintenanceExpiryDate()).isBeforeExpiry(date);
    }

    @Override
    public boolean isLicensedForDataCenter() {
        return true;
    }

    private boolean isEnterprise(BitbucketServerLicense license) {
        return "true".equals(license.getProperty("ELA"));
    }

    @Override
    public boolean isExpired() {
        BitbucketServerLicense license = this.licenseService.get();
        return license == null || license.isExpired();
    }
}

