/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bitbucket;

import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.mail.Email;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.atlassian.troubleshooting.stp.salext.mail.AbstractMailUtility;
import com.atlassian.troubleshooting.stp.salext.mail.MailQueueItemFactory;
import com.atlassian.troubleshooting.stp.salext.mail.MailServerManagerProvider;
import com.atlassian.troubleshooting.stp.salext.mail.SupportRequest;
import com.atlassian.troubleshooting.stp.salext.mail.SupportRequestAttachment;
import jakarta.activation.DataSource;
import jakarta.annotation.Nonnull;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BitbucketMailUtility
extends AbstractMailUtility {
    private static final Logger LOG = LoggerFactory.getLogger(BitbucketMailUtility.class);
    private final ApplicationPropertiesService applicationPropertiesService;
    private final MailService mailService;

    @Autowired
    public BitbucketMailUtility(@Nonnull @ComponentImport ApplicationPropertiesService applicationPropertiesService, @Nonnull @ComponentImport MailService mailService, @Nonnull MailQueueItemFactory mailQueueItemFactory, @Nonnull MailServerManagerProvider factoryProvider) {
        super(mailQueueItemFactory, factoryProvider);
        this.applicationPropertiesService = Objects.requireNonNull(applicationPropertiesService);
        this.mailService = Objects.requireNonNull(mailService);
    }

    @Override
    public String getDefaultFromAddress() {
        return this.applicationPropertiesService.getServerEmailAddress();
    }

    @Override
    public boolean isMailServerConfigured() {
        return this.mailService.isHostConfigured();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendSupportRequestEmail(SupportRequest requestInfo, SupportApplicationInfo info) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.mailService.getClass().getClassLoader());
            MailMessage.Builder builder = new MailMessage.Builder().from(requestInfo.getFromAddress()).subject(requestInfo.getSubject()).text(requestInfo.getBody()).to(new String[]{requestInfo.getToAddress()});
            for (Map.Entry<String, String> header : requestInfo.getHeaders()) {
                builder.header(header.getKey(), header.getValue());
            }
            for (SupportRequestAttachment attachment : requestInfo.getAttachments()) {
                Serializable data = attachment.getData();
                if (data instanceof byte[]) {
                    builder.attachment(attachment.getName(), (DataSource)new ByteArrayDataSource((byte[])data, attachment.getType()));
                    continue;
                }
                if (data instanceof String) {
                    builder.attachment(attachment.getName(), (DataSource)new ByteArrayDataSource(((String)((Object)data)).getBytes(), attachment.getType()));
                    continue;
                }
                if (data instanceof File) {
                    builder.attachment(attachment.getName(), (File)data);
                    continue;
                }
                LOG.warn("Attachment [{}], of declared type [{}], contains unexpected data: '{}'. It will not be added to the mail message", (Object[])new String[]{attachment.getName(), attachment.getType(), data == null ? "(Null)" : data.getClass().getName()});
            }
            this.mailService.submit(builder.build());
            LOG.info("Sent support request to {} using configured MailService", (Object)requestInfo.getToAddress());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMail(Email email) {
        if (this.isMailServerConfigured()) {
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.mailService.getClass().getClassLoader());
                MailMessage.Builder builder = new MailMessage.Builder().from(email.getFrom()).subject(email.getSubject()).text(email.getBody()).to(new String[]{email.getTo()});
                Iterator iterator = email.getHeaders().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    builder.header(entry.getKey().toString(), entry.getValue().toString());
                }
                if (StringUtils.isNotBlank((CharSequence)email.getMimeType())) {
                    builder.header("Content-Type", email.getMimeType());
                }
                this.mailService.submit(builder.build());
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        } else {
            LOG.warn("Unable to send mail as mail server is not configured.");
        }
    }
}

