/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bitbucket.jfr;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.troubleshooting.jfr.config.JfrServiceProductSupport;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public class BitbucketJfrServiceProductSupport
implements JfrServiceProductSupport {
    private static final int JFR_ACTIVATION_BUILD = 7017000;
    private static final int JFR_RUNNING_BY_DEFAULT_BUILD = 8003000;
    private final DarkFeatureManager darkFeatureManager;
    private final ApplicationProperties applicationProperties;

    @Autowired
    public BitbucketJfrServiceProductSupport(DarkFeatureManager darkFeatureManager, ApplicationProperties applicationProperties) {
        this.darkFeatureManager = Objects.requireNonNull(darkFeatureManager);
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
    }

    @Override
    public boolean isSupported() {
        boolean disabledExplicit = this.darkFeatureManager.isEnabledForAllUsers("com.atlassian.troubleshooting.jfr.disabled").orElse(false);
        if (disabledExplicit) {
            return false;
        }
        boolean enabledExplicit = this.darkFeatureManager.isEnabledForAllUsers("com.atlassian.troubleshooting.jfr.enabled").orElse(false);
        if (enabledExplicit) {
            return true;
        }
        return this.isActivatedByDefault();
    }

    private boolean isActivatedByDefault() {
        return Long.parseLong(this.applicationProperties.getBuildNumber()) >= 7017000L;
    }

    @Override
    public boolean isRunningByDefault() {
        return Long.parseLong(this.applicationProperties.getBuildNumber()) >= 8003000L;
    }
}

