/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bitbucket.pup;

import com.atlassian.bitbucket.scm.git.GitScm;
import com.atlassian.bitbucket.search.SearchInformationService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.DatabaseType;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.troubleshooting.api.healthcheck.OptionalServiceProvider;
import com.atlassian.troubleshooting.healthcheck.accessors.DbPlatform;
import com.atlassian.troubleshooting.healthcheck.accessors.DbPlatformFactory;
import com.atlassian.troubleshooting.healthcheck.impl.DbVersionExtractor;
import com.atlassian.troubleshooting.healthcheck.model.DbType;
import com.atlassian.troubleshooting.healthcheck.model.SearchDistribution;
import com.atlassian.troubleshooting.preupgrade.BitbucketPupPlatformAccessor;
import com.atlassian.troubleshooting.preupgrade.SearchServer;
import com.atlassian.troubleshooting.preupgrade.SearchServerFactory;
import com.atlassian.troubleshooting.preupgrade.model.MicroservicePreUpgradeDataDTO;
import com.atlassian.troubleshooting.preupgrade.modz.Modifications;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.SystemUtils;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BitbucketPupPlatformAccessorImpl
implements BitbucketPupPlatformAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BitbucketPupPlatformAccessorImpl.class);
    private final ApplicationProperties applicationProperties;
    private final GitScm gitScm;
    private final ApplicationPropertiesService applicationPropertiesService;
    private final DbPlatformFactory dbPlatformFactory;
    private final OptionalServiceProvider optionalServiceProvider;
    private final SearchServerFactory searchServerFactory;
    private final DbVersionExtractor dbVersionExtractor;

    @Autowired
    public BitbucketPupPlatformAccessorImpl(BundleContext bundleContext, ApplicationProperties applicationProperties, @ComponentImport GitScm gitScm, @ComponentImport ApplicationPropertiesService applicationPropertiesService, DbPlatformFactory dbPlatformFactory, DbVersionExtractor dbVersionExtractor, OptionalServiceProvider optionalServiceProvider, SearchServerFactory searchServerFactory) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.gitScm = Objects.requireNonNull(gitScm);
        this.applicationPropertiesService = Objects.requireNonNull(applicationPropertiesService);
        this.dbPlatformFactory = Objects.requireNonNull(dbPlatformFactory);
        this.dbVersionExtractor = dbVersionExtractor;
        this.optionalServiceProvider = Objects.requireNonNull(optionalServiceProvider);
        this.searchServerFactory = Objects.requireNonNull(searchServerFactory);
    }

    @Override
    public Optional<Modifications> getModifiedFiles() {
        return Optional.empty();
    }

    @Override
    public MicroservicePreUpgradeDataDTO.Version.SubProduct calculateSubProduct() {
        return MicroservicePreUpgradeDataDTO.Version.SubProduct.BITBUCKET;
    }

    @Override
    public Optional<DbPlatform> getCurrentDbPlatform() {
        Optional<DbType> type = this.toAtstDbType(this.applicationPropertiesService.getDatabaseType());
        String dbVersion = this.applicationPropertiesService.getDatabaseVersion();
        if (dbVersion.isEmpty()) {
            return type.map(dbType -> this.dbPlatformFactory.create((DbType)((Object)dbType), ""));
        }
        return type.map(dbType -> this.dbPlatformFactory.create((DbType)((Object)dbType), this.dbVersionExtractor.getSupportedPlatformVersionComparisonString((DbType)((Object)((Object)type.get())), dbVersion)));
    }

    @Override
    public String getVersion() {
        return this.applicationProperties.getVersion();
    }

    @Override
    public String getGitVersion() {
        Optional version = this.gitScm.getVersion();
        return version.isPresent() ? ((Version)version.get()).toString() : "0.0.0";
    }

    @Override
    public Optional<SearchServer> getSearchServer() {
        Optional<Object> maybeService = this.optionalServiceProvider.get("com.atlassian.bitbucket.search.SearchInformationService");
        if (!maybeService.isPresent()) {
            LOGGER.debug("searchInformationService is not available on this instance");
            return Optional.empty();
        }
        SearchInformationService searchInformationService = (SearchInformationService)maybeService.get();
        Optional maybeDistribution = searchInformationService.getDistribution();
        SearchDistribution searchDistribution = null;
        if (maybeDistribution.isPresent()) {
            com.atlassian.bitbucket.search.SearchDistribution searchDistn = (com.atlassian.bitbucket.search.SearchDistribution)maybeDistribution.get();
            if (searchDistn == com.atlassian.bitbucket.search.SearchDistribution.OPENSEARCH) {
                searchDistribution = SearchDistribution.OPENSEARCH;
            } else if (searchDistn == com.atlassian.bitbucket.search.SearchDistribution.ELASTICSEARCH) {
                searchDistribution = SearchDistribution.ELASTICSEARCH;
            } else {
                LOGGER.debug("Unknown search distribution provided from Bitbucket: {}", (Object)searchDistn);
                searchDistribution = SearchDistribution.UNKNOWN;
            }
        }
        String version = searchInformationService.getVersion().map(v -> com.atlassian.troubleshooting.stp.spi.Version.of(v.getMajor(), v.getMinor(), v.getPatch())).map(com.atlassian.troubleshooting.stp.spi.Version::toString).orElse(null);
        if (searchDistribution == null || version == null) {
            return Optional.empty();
        }
        return Optional.of(this.searchServerFactory.create(searchDistribution, version));
    }

    @Override
    public boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    @VisibleForTesting
    protected Optional<DbType> toAtstDbType(DatabaseType bbDatabaseType) {
        switch (bbDatabaseType) {
            case H2: {
                return Optional.of(DbType.h2);
            }
            case ORACLE: {
                return Optional.of(DbType.oracle);
            }
            case POSTGRES: {
                return Optional.of(DbType.postgres);
            }
            case SQLSERVER: {
                return Optional.of(DbType.sqlServer);
            }
        }
        return Optional.empty();
    }
}

