/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bitbucket.spring;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.api.supportzip.BundleCategory;
import com.atlassian.troubleshooting.api.supportzip.SupportZipBundle;
import com.atlassian.troubleshooting.bitbucket.BitbucketApplicationInfo;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.atlassian.troubleshooting.stp.salext.bundle.AuthenticationConfigurationFileBundle;
import com.atlassian.troubleshooting.stp.salext.bundle.BundleManifest;
import com.atlassian.troubleshooting.stp.salext.bundle.FileSetsBundle;
import com.atlassian.troubleshooting.stp.salext.bundle.fileset.ExactFileSet;
import com.atlassian.troubleshooting.stp.salext.bundle.fileset.RegexFileSet;
import com.google.common.annotations.VisibleForTesting;
import java.util.regex.Pattern;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BitbucketSupportZipBundleBeans {
    @VisibleForTesting
    public static final Pattern LOG_FILE_PATTERN = Pattern.compile("(^(?!.*audit).*\\.log.*)");
    private static final String BITBUCKET_PROPERTIES = "bitbucket.properties";
    private static final Pattern YML_FILE_PATTERN = Pattern.compile("^.*\\.yml$");
    private static final String ZIP_INCLUDE_BITBUCKET_LOGS_DESCRIPTION = "stp.zip.include.bitbucket.logs.description";
    private static final String ZIP_INCLUDE_BITBUCKET_LOGS = "stp.zip.include.bitbucket.logs";
    private static final String ZIP_INCLUDE_BITBUCKET_CFG_DESCRIPTION = "stp.zip.include.bitbucket.cfg.description";
    private static final String ZIP_INCLUDE_BITBUCKET_CFG = "stp.zip.include.bitbucket.cfg";
    private final I18nResolver i18nResolver;

    @Autowired
    public BitbucketSupportZipBundleBeans(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportApplicationConfigBundle(BitbucketApplicationInfo info) {
        String localHome = info.getApplicationHome();
        String sharedHome = info.getSharedApplicationHome();
        String searchConfigurationDir = sharedHome + "/search";
        return OsgiServices.exportOsgiService(FileSetsBundle.builder(BundleManifest.APPLICATION_CONFIG, ZIP_INCLUDE_BITBUCKET_CFG, ZIP_INCLUDE_BITBUCKET_CFG_DESCRIPTION, BundleCategory.CONFIG, this.i18nResolver).fileSet(ExactFileSet.ofPaths(sharedHome + "/bitbucket.properties")).fileSet(ExactFileSet.ofPaths(localHome + "/bitbucket.properties"), "local").fileSet(RegexFileSet.fromDirectoryPath(searchConfigurationDir, YML_FILE_PATTERN)).fileSet(RegexFileSet.fromDirectoryPath(searchConfigurationDir + "/buckler", YML_FILE_PATTERN)).build(), ExportOptions.as(SupportZipBundle.class, new Class[0]));
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportApplicationLogsBundle(SupportApplicationInfo info) {
        return OsgiServices.exportOsgiService(FileSetsBundle.builder(BundleManifest.APPLICATION_LOGS, ZIP_INCLUDE_BITBUCKET_LOGS, ZIP_INCLUDE_BITBUCKET_LOGS_DESCRIPTION, BundleCategory.LOGS, this.i18nResolver).fileSet(RegexFileSet.fromDirectoryPath(info.getApplicationHome() + "/log", LOG_FILE_PATTERN)).fileSet(RegexFileSet.fromDirectoryPath(info.getApplicationHome() + "/log/search", Pattern.compile(".*"))).build(), ExportOptions.as(SupportZipBundle.class, new Class[0]));
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportAuthenticationConfigurationBundle(SupportApplicationInfo info, @ComponentImport CrowdDirectoryService dirService) {
        return OsgiServices.exportOsgiService(new AuthenticationConfigurationFileBundle(dirService, this.i18nResolver, new String[0]), ExportOptions.as(SupportZipBundle.class, new Class[0]));
    }
}

