/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bitbucket.zip;

import com.atlassian.troubleshooting.bitbucket.zip.SupportZipCancelTopic;
import com.atlassian.troubleshooting.bitbucket.zip.SupportZipCreateTopic;
import com.atlassian.troubleshooting.stp.zip.ClusteredSupportZipService;
import com.atlassian.troubleshooting.stp.zip.SupportZipRequest;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class BitbucketClusteredSupportZipService
implements ClusteredSupportZipService {
    private static final Logger LOG = LoggerFactory.getLogger(BitbucketClusteredSupportZipService.class);
    private final SupportZipCreateTopic supportZipCreateTopic;
    private final SupportZipCancelTopic supportZipCancelTopic;

    @Autowired
    public BitbucketClusteredSupportZipService(SupportZipCreateTopic supportZipCreateTopic, SupportZipCancelTopic supportZipCancelTopic) {
        this.supportZipCreateTopic = Objects.requireNonNull(supportZipCreateTopic);
        this.supportZipCancelTopic = Objects.requireNonNull(supportZipCancelTopic);
    }

    @Override
    @Nonnull
    public Optional<String> requestSupportZipCreationOnOtherNodes(SupportZipRequest supportZipRequest) {
        try {
            this.supportZipCreateTopic.publish(supportZipRequest);
            return Optional.empty();
        }
        catch (Exception e) {
            LOG.error("Unable to request support creation of another node", (Throwable)e);
            return Optional.of(e.getMessage());
        }
    }

    @Override
    public void requestSupportZipCancellationOnOtherNodes(String taskId) {
        this.supportZipCancelTopic.publish(taskId);
    }
}

