/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bitbucket.zip;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.troubleshooting.bitbucket.zip.AuthenticatedMessage;
import com.atlassian.troubleshooting.bitbucket.zip.MirrorFarmService;
import com.atlassian.troubleshooting.bitbucket.zip.SupportZipCancelTopic;
import com.atlassian.troubleshooting.bitbucket.zip.SupportZipCreateTopic;
import com.atlassian.troubleshooting.bitbucket.zip.SupportZipProgressTopic;
import com.atlassian.troubleshooting.stp.persistence.TaskMonitorRepository;
import com.atlassian.troubleshooting.stp.task.TaskMonitor;
import com.atlassian.troubleshooting.stp.task.TaskMonitorListener;
import com.atlassian.troubleshooting.stp.task.TaskMonitorRepositoryFactory;
import com.atlassian.troubleshooting.stp.task.TaskType;
import com.atlassian.troubleshooting.stp.util.ObjectMapperFactory;
import com.atlassian.troubleshooting.stp.zip.CreateSupportZipMonitor;
import com.atlassian.troubleshooting.stp.zip.SupportZipRequest;
import com.atlassian.troubleshooting.stp.zip.SupportZipService;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={LifecycleAware.class})
public class BitbucketSupportZipListener
implements LifecycleAware {
    private static final Logger LOG = LoggerFactory.getLogger(BitbucketSupportZipListener.class);
    private final SupportZipCreateTopic supportZipCreateTopic;
    private final SupportZipCancelTopic supportZipCancelTopic;
    private final SupportZipService supportZipService;
    private final SupportZipProgressTopic supportZipProgressTopic;
    private final MirrorFarmService mirrorFarmService;
    private final ClusterService clusterService;
    private final TaskMonitorRepository<CreateSupportZipMonitor> repository;
    private String subscriptionCreateId;
    private String subscriptionCancelId;
    private String subscriptionProgressId;

    @Autowired
    public BitbucketSupportZipListener(SupportZipService supportZipService, SupportZipCreateTopic supportZipCreateTopic, SupportZipCancelTopic supportZipCancelTopic, SupportZipProgressTopic supportZipProgressTopic, MirrorFarmService mirrorFarmService, ClusterService clusterService, TaskMonitorRepositoryFactory taskMonitorRepositoryFactory) {
        this.supportZipCreateTopic = Objects.requireNonNull(supportZipCreateTopic);
        this.supportZipCancelTopic = Objects.requireNonNull(supportZipCancelTopic);
        this.supportZipService = Objects.requireNonNull(supportZipService);
        this.supportZipProgressTopic = Objects.requireNonNull(supportZipProgressTopic);
        this.mirrorFarmService = mirrorFarmService;
        this.clusterService = clusterService;
        this.repository = taskMonitorRepositoryFactory.getRepository(TaskType.SUPPORT_ZIP);
    }

    public void onStart() {
        this.subscriptionCreateId = this.supportZipCreateTopic.subscribe(BitbucketSupportZipListener.filterRemoteOnly(this::createSupportZip));
        this.subscriptionCancelId = this.supportZipCancelTopic.subscribe(BitbucketSupportZipListener.filterRemoteOnly(this::cancelSupportZip));
        this.subscriptionProgressId = this.supportZipProgressTopic.subscribe(BitbucketSupportZipListener.filterRemoteOnly(this::syncLocalMonitor));
    }

    private static <T extends Serializable> TopicListener<T> filterRemoteOnly(TopicListener<T> listener) {
        return e -> {
            if (!e.getSource().isLocal()) {
                listener.onMessage(e);
            }
        };
    }

    public void onStop() {
        if (this.subscriptionCreateId != null) {
            this.supportZipCreateTopic.unsubscribe(this.subscriptionCreateId);
            this.subscriptionCreateId = null;
        }
        if (this.subscriptionCancelId != null) {
            this.supportZipCancelTopic.unsubscribe(this.subscriptionCancelId);
            this.subscriptionCancelId = null;
        }
        if (this.subscriptionProgressId != null) {
            this.supportZipProgressTopic.unsubscribe(this.subscriptionProgressId);
            this.subscriptionProgressId = null;
        }
    }

    private void createSupportZip(MessageEvent<AuthenticatedMessage<String>> event) {
        String supportZipRequestJson = (String)((AuthenticatedMessage)event.getMessage()).getMessage();
        this.deserializeSupportZipRequest(supportZipRequestJson).ifPresent(request -> {
            CreateSupportZipMonitor monitor = this.supportZipService.createLocalSupportZipWithoutPermissionCheck((SupportZipRequest)request);
            if (monitor != null && this.mirrorFarmService.isMirrorFarm()) {
                monitor.addListener(new SupportZipProgressPublisher(monitor));
                this.supportZipProgressTopic.publish(monitor);
            }
        });
    }

    private Optional<SupportZipRequest> deserializeSupportZipRequest(String supportZipRequestJson) {
        try {
            return Optional.of((SupportZipRequest)ObjectMapperFactory.getObjectMapper().readValue(supportZipRequestJson, SupportZipRequest.class));
        }
        catch (IOException e) {
            LOG.error("Cannot convert Json value to SupportZipRequest: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    private void cancelSupportZip(MessageEvent<String> event) {
        String taskId = (String)event.getMessage();
        Optional<CreateSupportZipMonitor> maybeMonitor = this.supportZipService.getMonitorWithoutPermissionCheck(taskId);
        maybeMonitor.ifPresent(monitor -> {
            if (this.isRunningOnThisNode((CreateSupportZipMonitor)monitor)) {
                this.supportZipService.cancelSupportZipTaskOnThisNode((CreateSupportZipMonitor)monitor);
            } else if (this.mirrorFarmService.isMirrorFarm()) {
                this.repository.deleteTaskMonitor((CreateSupportZipMonitor)monitor);
            }
        });
    }

    private void syncLocalMonitor(MessageEvent<CreateSupportZipMonitor> event) {
        CreateSupportZipMonitor monitor = (CreateSupportZipMonitor)event.getMessage();
        if (monitor.getNodeId().isPresent() && !this.isRunningOnThisNode(monitor) && monitor.getClusteredTaskId().isPresent()) {
            this.createOrUpdateLocalMonitor(monitor);
        }
    }

    private void createOrUpdateLocalMonitor(CreateSupportZipMonitor monitor) {
        Collection<CreateSupportZipMonitor> existingMonitors = this.repository.getRecentTaskMonitorsByClusteredTaskId(monitor.getClusteredTaskId().get());
        if (existingMonitors.isEmpty()) {
            this.repository.storeTaskMonitor(monitor);
        } else {
            this.repository.updateTaskMonitor(monitor);
        }
    }

    private boolean isRunningOnThisNode(CreateSupportZipMonitor monitor) {
        return this.clusterService.getNodeId().equals(monitor.getNodeId().orElse(null));
    }

    private class SupportZipProgressPublisher
    implements TaskMonitorListener<File> {
        private final CreateSupportZipMonitor monitor;

        SupportZipProgressPublisher(CreateSupportZipMonitor monitor) {
            this.monitor = Objects.requireNonNull(monitor);
        }

        @Override
        public void onFinished(@Nonnull TaskMonitor<File> m) {
            BitbucketSupportZipListener.this.supportZipProgressTopic.publish(this.monitor);
        }

        @Override
        public void onUpdated(@Nonnull TaskMonitor<File> m) {
            BitbucketSupportZipListener.this.supportZipProgressTopic.publish(this.monitor);
        }
    }
}

