/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bitbucket.zip;

import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.auth.SimpleAuthentication;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.troubleshooting.bitbucket.zip.AuthenticatedMessage;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageAuthenticationService {
    private static final Logger LOG = LoggerFactory.getLogger(MessageAuthenticationService.class);
    private final AuthenticationService authenticationService;
    private final UserService userService;

    @Autowired
    public MessageAuthenticationService(@ComponentImport AuthenticationService authenticationService, @ComponentImport(value="bitbucketUserService") UserService userService) {
        this.authenticationService = Objects.requireNonNull(authenticationService);
        this.userService = Objects.requireNonNull(userService);
    }

    public <T extends Serializable> AuthenticatedMessage<T> wrap(T message) {
        return new AuthenticatedMessage<T>(message, this.authenticationService.get().getUser().map(ApplicationUser::getId));
    }

    public <T extends Serializable> TopicListener<AuthenticatedMessage<T>> authenticateListener(TopicListener<AuthenticatedMessage<T>> listener) {
        return e -> {
            try {
                ((AuthenticatedMessage)e.getMessage()).getUserId().ifPresent(id -> {
                    try {
                        this.authenticationService.set(SimpleAuthentication.builder((ApplicationUser)this.userService.getUserById(id.intValue())).build());
                    }
                    catch (Throwable t) {
                        LOG.error("Failed setting authentication to user " + id, t);
                    }
                });
                listener.onMessage(e);
            }
            finally {
                this.authenticationService.clear();
            }
        };
    }
}

