/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.bitbucket.zip;

import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.troubleshooting.bitbucket.zip.AuthenticatedMessage;
import com.atlassian.troubleshooting.bitbucket.zip.MessageAuthenticationService;
import com.atlassian.troubleshooting.stp.util.ObjectMapperFactory;
import com.atlassian.troubleshooting.stp.zip.SupportZipRequest;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SupportZipCreateTopic {
    private static final Logger LOG = LoggerFactory.getLogger(SupportZipCreateTopic.class);
    private static final String TOPIC_NAME = "SUPPORT_ZIP_TOPIC_CREATE_AUTH";
    private static final TopicSettings<AuthenticatedMessage<String>> TOPIC_SETTINGS = new TopicSettings.Builder(AuthenticatedMessage.class).build();
    private final Topic<AuthenticatedMessage<String>> supportTopic;
    private final MessageAuthenticationService messageAuthenticationService;

    @Autowired
    public SupportZipCreateTopic(@ComponentImport TopicService topicService, MessageAuthenticationService messageAuthenticationService) {
        this.supportTopic = topicService.getTopic(TOPIC_NAME, TOPIC_SETTINGS);
        this.messageAuthenticationService = Objects.requireNonNull(messageAuthenticationService);
    }

    public void publish(SupportZipRequest supportZipRequest) {
        Objects.requireNonNull(supportZipRequest);
        this.serializeSupportZipRequest(supportZipRequest).map(this.messageAuthenticationService::wrap).ifPresent(arg_0 -> this.supportTopic.publish(arg_0));
    }

    @Nonnull
    public String subscribe(@Nonnull TopicListener<AuthenticatedMessage<String>> listener) {
        Objects.requireNonNull(listener);
        return this.supportTopic.subscribe(this.messageAuthenticationService.authenticateListener(listener));
    }

    public boolean unsubscribe(@Nonnull String subscriptionId) {
        return this.supportTopic.unsubscribe(subscriptionId);
    }

    private Optional<String> serializeSupportZipRequest(SupportZipRequest supportZipRequest) {
        try {
            return Optional.of(ObjectMapperFactory.getObjectMapper().writeValueAsString((Object)supportZipRequest));
        }
        catch (IOException e) {
            LOG.error("Cannot publish supportZipRequest to other nodes due to the failure of Json serialization: ", (Throwable)e);
            return Optional.empty();
        }
    }
}

