/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.certificates;

import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.impl.CertificatesHealthCheckServiceProvider;
import com.atlassian.upm.signing.healthcheck.api.CertificatesHealthCheckService;
import java.io.Serializable;

public class CertificatesExpirationCheck
implements SupportHealthCheck {
    private static final int DEFAULT_DAYS_BEFORE_EXPIRATION = 30;
    private static final String DAYS_BEFORE_EXPIRATION_PROPERTY = "certificates.healthcheck.days.before.expiration";
    private final SupportHealthStatusBuilder healthStatusBuilder;
    private final CertificatesHealthCheckServiceProvider certificatesHealthCheckServiceProvider;
    private final int daysBeforeExpiration;

    public CertificatesExpirationCheck(CertificatesHealthCheckServiceProvider certificatesHealthCheckServiceProvider, SupportHealthStatusBuilder healthStatusBuilder, int daysBeforeExpiration) {
        this.healthStatusBuilder = healthStatusBuilder;
        this.certificatesHealthCheckServiceProvider = certificatesHealthCheckServiceProvider;
        this.daysBeforeExpiration = daysBeforeExpiration;
    }

    public CertificatesExpirationCheck(CertificatesHealthCheckServiceProvider certificatesHealthCheckServiceProvider, SupportHealthStatusBuilder healthStatusBuilder) {
        this(certificatesHealthCheckServiceProvider, healthStatusBuilder, CertificatesExpirationCheck.getDaysBeforeExpiration());
    }

    private static int getDaysBeforeExpiration() {
        String daysBeforeExpirationPropertyValue = System.getProperty(DAYS_BEFORE_EXPIRATION_PROPERTY);
        if (daysBeforeExpirationPropertyValue != null) {
            try {
                return Integer.parseInt(daysBeforeExpirationPropertyValue);
            }
            catch (NumberFormatException numberFormatException) {
                return 30;
            }
        }
        return 30;
    }

    @Override
    public SupportHealthStatus check() {
        CertificatesHealthCheckService certificatesHealthCheckService = this.certificatesHealthCheckServiceProvider.getServiceWrapper().getService();
        if (certificatesHealthCheckService != null) {
            if (certificatesHealthCheckService.getCertificatesExpiringWithin(this.daysBeforeExpiration).isEmpty()) {
                return this.healthStatusBuilder.ok(this, "healthcheck.certificatesExpiration.ok", Integer.valueOf(this.daysBeforeExpiration));
            }
            return this.healthStatusBuilder.warning(this, "healthcheck.certificatesExpiration.warn", new Serializable[0]);
        }
        return this.healthStatusBuilder.ok(this, "healthcheck.certificatesExpiration.disabled", new Serializable[0]);
    }
}

