/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.certificates;

import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.impl.CertificatesHealthCheckServiceProvider;
import com.atlassian.upm.signing.healthcheck.api.CertificateStorageHealthStatus;
import com.atlassian.upm.signing.healthcheck.api.CertificatesHealthCheckService;
import java.io.Serializable;

public class CertificatesFolderHealthCheck
implements SupportHealthCheck {
    private final SupportHealthStatusBuilder healthStatusBuilder;
    private final CertificatesHealthCheckServiceProvider certificatesHealthCheckServiceProvider;

    public CertificatesFolderHealthCheck(CertificatesHealthCheckServiceProvider certificatesHealthCheckServiceProvider, SupportHealthStatusBuilder healthStatusBuilder) {
        this.certificatesHealthCheckServiceProvider = certificatesHealthCheckServiceProvider;
        this.healthStatusBuilder = healthStatusBuilder;
    }

    @Override
    public SupportHealthStatus check() {
        CertificatesHealthCheckService service = this.certificatesHealthCheckServiceProvider.getServiceWrapper().getService();
        if (service != null) {
            CertificateStorageHealthStatus status = service.getCertificatesStorageHealthStatus();
            if (status.getStatus() == CertificateStorageHealthStatus.Status.SUCCESS) {
                return this.healthStatusBuilder.ok(this, "healthcheck.certificatesFolder.ok", new Serializable[0]);
            }
            return this.healthStatusBuilder.warning(this, "healthcheck.certificatesFolder.warn", new Serializable[0]);
        }
        return this.healthStatusBuilder.ok(this, "healthcheck.certificatesFolder.disabled", new Serializable[0]);
    }
}

