/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.clientcredentials;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.oauth2.ApplinkOAuth2Service;
import com.atlassian.oauth2.provider.api.client.ClientExpirationEvaluator;
import com.atlassian.troubleshooting.healthcheck.checks.clientcredentials.ClientService;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;

public class ApplinksClientService
extends ClientService {
    private final ApplicationLinkService applicationLinkService;
    private final ApplinkOAuth2Service applinkOAuth2Service;

    @Autowired
    public ApplinksClientService(ApplicationLinkService applicationLinkService, ClientExpirationEvaluator clientExpirationEvaluator, ApplinkOAuth2Service applinkOAuth2Service) {
        super(clientExpirationEvaluator);
        this.applicationLinkService = applicationLinkService;
        this.applinkOAuth2Service = applinkOAuth2Service;
    }

    public Set<String> getInternalApplinkClientIds() {
        return StreamSupport.stream(this.applicationLinkService.getApplicationLinks().spliterator(), false).map(ReadOnlyApplicationLink::getClientId).collect(Collectors.toSet());
    }

    public Set<String> getExternalApplinkClientIds() {
        return StreamSupport.stream(this.applinkOAuth2Service.getApplicationLinksForOAuth2Provider().spliterator(), false).map(ReadOnlyApplicationLink::getId).map(ApplicationId::get).collect(Collectors.toSet());
    }
}

