/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.clientcredentials;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.external.OAuth2ProviderService;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.checks.clientcredentials.ApplinksClientService;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ApplinksCredentialsExpirationHealthCheck
implements SupportHealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ApplinksCredentialsExpirationHealthCheck.class);
    private final SupportHealthStatusBuilder healthStatusBuilder;
    private final OAuth2ProviderService oAuth2ProviderService;
    private final ApplinksClientService applinksClientService;
    private final ActiveObjects activeObjects;

    @Autowired
    public ApplinksCredentialsExpirationHealthCheck(SupportHealthStatusBuilder healthStatusBuilder, OAuth2ProviderService oAuth2ProviderService, ApplinksClientService applinksClientService, ActiveObjects activeObjects) {
        this.healthStatusBuilder = healthStatusBuilder;
        this.oAuth2ProviderService = oAuth2ProviderService;
        this.applinksClientService = applinksClientService;
        this.activeObjects = activeObjects;
    }

    @Override
    public SupportHealthStatus check() {
        return (SupportHealthStatus)this.activeObjects.executeInTransaction(() -> {
            LOG.debug("Checking Application Links client credentials expiration");
            List clientList = this.oAuth2ProviderService.listClients();
            Set<String> internalApplinksClientIds = this.applinksClientService.getInternalApplinkClientIds();
            Set<String> externalApplinkClientIds = this.applinksClientService.getExternalApplinkClientIds();
            Set<String> applinkClientIds = clientList.stream().map(Client::getId).filter(clientId -> internalApplinksClientIds.contains(clientId) || externalApplinkClientIds.contains(clientId)).collect(Collectors.toSet());
            long totalApplinkClients = this.applinksClientService.getTotalClientsCount(clientList, applinkClientIds);
            Set<Client> expiredApplinksClients = this.applinksClientService.getExpiredClients(clientList, applinkClientIds);
            long expiredApplinksClientsCount = expiredApplinksClients.size();
            long soonToExpireApplinksClientsCount = this.applinksClientService.getSoonToExpireClientsCount(clientList, applinkClientIds, expiredApplinksClients);
            LOG.debug("Found {} expired and {} soon to expire Application Links clients out of {} total Application Links clients", new Object[]{expiredApplinksClientsCount, soonToExpireApplinksClientsCount, totalApplinkClients});
            if (expiredApplinksClientsCount > 0L && soonToExpireApplinksClientsCount > 0L) {
                return this.healthStatusBuilder.major(this, "healthcheck.application.links.client.credentials.check.expired.and.soon.to.expire", Long.valueOf(expiredApplinksClientsCount), Long.valueOf(totalApplinkClients), Long.valueOf(soonToExpireApplinksClientsCount));
            }
            if (expiredApplinksClientsCount > 0L) {
                return this.healthStatusBuilder.major(this, "healthcheck.application.links.client.credentials.check.expired", Long.valueOf(expiredApplinksClientsCount), Long.valueOf(totalApplinkClients));
            }
            if (soonToExpireApplinksClientsCount > 0L) {
                return this.healthStatusBuilder.warning(this, "healthcheck.application.links.client.credentials.check.soon.to.expire", Long.valueOf(soonToExpireApplinksClientsCount), Long.valueOf(totalApplinkClients));
            }
            return this.healthStatusBuilder.ok(this, "healthcheck.application.links.client.credentials.check.valid", new Serializable[0]);
        });
    }
}

