/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.impl;

import com.atlassian.plugins.osgi.javaconfig.ImportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.upm.signing.healthcheck.api.CertificatesHealthCheckService;
import java.util.function.Supplier;

public class CertificatesHealthCheckServiceProvider {
    public CertificatesHealthCheckServiceWrapper getServiceWrapper() {
        return new CertificatesHealthCheckServiceWrapper();
    }

    public boolean hasService() {
        return this.getServiceWrapper().getService() != null;
    }

    public Supplier<Boolean> visibilitySupplier() {
        return () -> {
            if (this.hasService()) {
                return this.getServiceWrapper().isSignatureCheckEnabled();
            }
            return false;
        };
    }

    public static final class CertificatesHealthCheckServiceWrapper {
        public CertificatesHealthCheckService getService() {
            try {
                Class<?> clazz = Class.forName("com.atlassian.upm.signing.healthcheck.api.CertificatesHealthCheckService");
                return (CertificatesHealthCheckService)OsgiServices.importOsgiService(clazz, ImportOptions.defaultOptions().optional());
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }

        public boolean isSignatureCheckEnabled() {
            CertificatesHealthCheckService service = this.getService();
            if (service == null) {
                return false;
            }
            return service.isSignatureCheckEnabled();
        }
    }
}

