/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.persistence.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.troubleshooting.healthcheck.persistence.service.HealthCheckWatcherService;
import com.atlassian.troubleshooting.stp.persistence.SupportHealthcheckSchema;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.DBParam;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class HealthCheckWatcherServiceImpl
implements HealthCheckWatcherService {
    private static final int DEFAULT_DELETE_BATCH_SIZE = 100;
    private final ActiveObjects ao;
    private final int deleteBatchSize;

    @Autowired
    public HealthCheckWatcherServiceImpl(ActiveObjects ao) {
        this(ao, 100);
    }

    @VisibleForTesting
    HealthCheckWatcherServiceImpl(ActiveObjects ao, int deleteBatchSize) {
        this.ao = Objects.requireNonNull(ao);
        this.deleteBatchSize = deleteBatchSize;
    }

    @Override
    public boolean isWatching(UserKey userKey) {
        Objects.requireNonNull(userKey);
        return ((SupportHealthcheckSchema.Watcher[])this.ao.find(SupportHealthcheckSchema.Watcher.class, "USER_KEY = ?", new Object[]{userKey.getStringValue()})).length > 0;
    }

    @Override
    public void watch(UserKey userKey) {
        Objects.requireNonNull(userKey);
        if (!this.isWatching(userKey)) {
            ((SupportHealthcheckSchema.Watcher)this.ao.create(SupportHealthcheckSchema.Watcher.class, new DBParam[]{new DBParam("USER_KEY", (Object)userKey.getStringValue())})).save();
        }
    }

    @Override
    public void unwatch(UserKey userKey) {
        Objects.requireNonNull(userKey);
        this.ao.deleteWithSQL(SupportHealthcheckSchema.Watcher.class, "USER_KEY = ?", new Object[]{userKey.getStringValue()});
    }

    @Override
    public List<UserKey> getAllWatchers() {
        return Stream.of((SupportHealthcheckSchema.Watcher[])this.ao.find(SupportHealthcheckSchema.Watcher.class)).map(SupportHealthcheckSchema.Watcher::getUserKey).map(UserKey::new).toList();
    }

    @Override
    public void unwatch(@Nonnull List<UserKey> userKeys) {
        Objects.requireNonNull(userKeys);
        for (int i = 0; i < userKeys.size(); i += this.deleteBatchSize) {
            List<UserKey> batch = userKeys.subList(i, Math.min(i + this.deleteBatchSize, userKeys.size()));
            this.ao.deleteWithSQL(SupportHealthcheckSchema.Watcher.class, "USER_KEY IN (" + this.toQuestionMarks(batch) + ")", batch.stream().map(UserKey::getStringValue).toArray());
        }
    }

    private <T> String toQuestionMarks(@Nonnull Collection<T> ids) {
        return ids.stream().map(id -> "?").collect(Collectors.joining(", "));
    }
}

