/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.instance;

import com.atlassian.troubleshooting.instance.CloudInstanceMetadataStrategy;
import com.atlassian.troubleshooting.instance.CloudInstanceParser;
import com.atlassian.troubleshooting.instance.CloudProviderType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataServiceStrategy
implements CloudInstanceMetadataStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(CloudInstanceParser.class);
    private final CloudProviderType cloud;

    public MetadataServiceStrategy(CloudProviderType cloud) {
        this.cloud = cloud;
    }

    @Override
    public boolean isThisCloudProvider(HttpClient httpClient) {
        if (this.cloud.getMetadataUrlV1() != null && this.isMetadataSuccess(this.cloud.getMetadataUrlV1(), this.cloud.getV1Header(), httpClient)) {
            return true;
        }
        if (this.cloud.getMetadataUrlV2() != null && this.isMetadataSuccess(this.cloud.getMetadataUrlV2(), this.cloud.getV2Header(), httpClient)) {
            return true;
        }
        if (this.cloud.getTokenUrl() != null) {
            String apiToken = "";
            HttpPut apiTokenRequest = new HttpPut(this.cloud.getTokenUrl());
            apiTokenRequest.addHeader((String)this.cloud.getTokenRequestHeader().getKey(), (String)this.cloud.getTokenRequestHeader().getValue());
            try (CloseableHttpResponse response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)apiTokenRequest);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    apiToken = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                }
            }
            catch (Exception e) {
                LOG.debug("Could not get instance metadata token", (Throwable)e);
            }
            if (StringUtils.isNotBlank((CharSequence)apiToken) && this.isMetadataSuccess(this.cloud.getMetadataUrlV1(), (Pair<String, String>)Pair.of((Object)((String)this.cloud.getV2Header().getKey()), (Object)apiToken), httpClient)) {
                return true;
            }
        }
        LOG.debug("Cloud provider is not {}.", (Object)this.cloud);
        return false;
    }

    private boolean isMetadataSuccess(String metadataUrl, Pair<String, String> header, HttpClient httpClient) {
        boolean bl;
        block9: {
            LOG.debug("Calling instance metadata api with url {}", (Object)metadataUrl);
            HttpGet request = new HttpGet(metadataUrl);
            if (header != null) {
                request.addHeader((String)header.getKey(), (String)header.getValue());
            }
            CloseableHttpResponse response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)request);
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                boolean bl2 = bl = statusCode == 200;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.debug("Could not get instance metadata", (Throwable)e);
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    @Override
    public CloudProviderType getCloudProviderType() {
        return this.cloud;
    }
}

