/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.jfr.domain;

import com.atlassian.troubleshooting.jfr.config.JfrProperties;
import com.atlassian.troubleshooting.jfr.config.JfrProperty;
import com.atlassian.troubleshooting.jfr.domain.JfrPropertyDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class JfrPropertiesDto {
    @JsonProperty
    private final List<JfrPropertyDto> propertyList;

    JfrPropertiesDto(List<JfrPropertyDto> propertyList) {
        this.propertyList = propertyList;
    }

    public List<JfrPropertyDto> getJfrProperties() {
        return ImmutableList.copyOf(this.propertyList);
    }

    public static JfrPropertiesDto create(JfrProperties jfrProperties) {
        return new JfrPropertiesDto(Arrays.stream(JfrProperty.values()).map(property -> JfrPropertyDto.create(property, jfrProperties)).toList());
    }

    public static JfrPropertiesDto empty() {
        return new JfrPropertiesDto(Collections.emptyList());
    }
}

