/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.preupgrade;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.preupgrade.AbstractUpgradePathSectionFactory;
import com.atlassian.troubleshooting.preupgrade.AnalyticsKey;
import com.atlassian.troubleshooting.preupgrade.BitbucketPupPlatformAccessor;
import com.atlassian.troubleshooting.preupgrade.VersionUpgradeInfo;
import com.atlassian.troubleshooting.preupgrade.model.PreUpgradeInfoDto;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.atlassian.troubleshooting.util.RendererUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BitbucketClusteredUpgradePathSectionFactory
extends AbstractUpgradePathSectionFactory<BitbucketPupPlatformAccessor> {
    protected static final String SHUTDOWN_INFO_URL = "https://confluence.atlassian.com/x/kJZKLg";
    protected static final String ZDU_UPGRADE_INFO_URL = "https://confluence.atlassian.com/x/sYWAPQ";

    @Autowired
    protected BitbucketClusteredUpgradePathSectionFactory(I18nResolver i18n, SupportApplicationInfo supportApplicationInfo, BitbucketPupPlatformAccessor pupPlatformAccessor, @ComponentImport PluginMetadataManager pluginMetadataManager, @ComponentImport PluginAccessor pluginAccessor) {
        super(i18n, supportApplicationInfo, pupPlatformAccessor, pluginMetadataManager, pluginAccessor, "bitbucket", true, "upgrade-path-bb-cluster", "https://docs.atlassian.com/bitbucketserver/docs-0%s%s/%s");
    }

    @Override
    public List<PreUpgradeInfoDto.Version.UpgradePathSection> getSections(VersionUpgradeInfo versionUpgradeInfo, boolean isZduAvailable) {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object[])new PreUpgradeInfoDto.Version.UpgradePathSection[]{this.createChooseAnUpgradeMethodSection(versionUpgradeInfo, isZduAvailable), this.createUpgradeInATestEnvironmentSection(versionUpgradeInfo, isZduAvailable)});
        if (isZduAvailable) {
            builder.add((Object)this.createUpgradeUsingZduInTestSection(versionUpgradeInfo));
        }
        builder.add((Object)this.createUpgradeInProdSection(versionUpgradeInfo, isZduAvailable));
        if (isZduAvailable) {
            builder.add((Object)this.createUpgradeUsingZduInProdSection(versionUpgradeInfo));
        }
        builder.add((Object)this.createPostUpgradeSection());
        return builder.build();
    }

    @VisibleForTesting
    protected PreUpgradeInfoDto.Version.UpgradePathSection createChooseAnUpgradeMethodSection(VersionUpgradeInfo versionUpgradeInfo, boolean isZduAvailable) {
        return new AbstractUpgradePathSectionFactory.SectionBuilder(this, "2", AnalyticsKey.UPGRADE_METHOD, "choose-upgrade-method", new Serializable[0]).descriptionArgs(new String[]{this.supportApplicationInfo.getApplicationName(), versionUpgradeInfo.getTargetVersion().getUpgradeInstructionsUrl(), isZduAvailable ? "<br><br>" + this.i18n.getText("stp.pup.upgrade-path-bb-cluster.description.zero-downtime-paragraph", new Serializable[]{this.supportApplicationInfo.getApplicationName()}) : ""}).build();
    }

    @VisibleForTesting
    protected PreUpgradeInfoDto.Version.UpgradePathSection createUpgradeInATestEnvironmentSection(VersionUpgradeInfo versionUpgradeInfo, boolean isZduAvailable) {
        String productDisplayName = this.supportApplicationInfo.getApplicationName();
        AbstractUpgradePathSectionFactory.SectionBuilder builder = new AbstractUpgradePathSectionFactory.SectionBuilder(this, isZduAvailable ? "3a" : "3", AnalyticsKey.TEST_UPGRADE, "upgrade-in-test-env", new Serializable[]{productDisplayName}).descriptionArgs(productDisplayName).step("create-staging-env", new Serializable[]{RendererUtils.renderLink(versionUpgradeInfo.getTargetVersion().getStagingEnvironmentInstructionsUrl(), this.i18n.getText("stp.pup.upgrade-path-bb-cluster.upgrade-in-test-env.staging-env-link"))}).step(this.hasApps(), "check-app-compatibility", new Serializable[]{this.getWebContext() + "/plugins/servlet/upm/check?source=manage", productDisplayName}).step(versionUpgradeInfo.isInstallerAvailable(), "download-product", new Serializable[]{productDisplayName}).step(!versionUpgradeInfo.isInstallerAvailable(), "download-product-without-installer", new Serializable[]{productDisplayName}).step("stop-nodes", new Serializable[]{productDisplayName}).step("backup-your-data", new Serializable[0]);
        builder.startNewSubSection("first-node-in-test", new Serializable[0]).step(versionUpgradeInfo.isInstallerAvailable(), "run-installer-or-upgrade-manually", new Serializable[0]).step(!versionUpgradeInfo.isInstallerAvailable(), "upgrade-manually", new Serializable[0]).step("apply-modifications", new Serializable[0]).step("start-application", new Serializable[]{productDisplayName}).step(this.hasApps(), "update-your-apps", new Serializable[]{this.getWebContext() + "/plugins/servlet/upm"}).step("stop-after-update", new Serializable[]{productDisplayName});
        builder.startNewSubSection("remaining-nodes-in-test", new Serializable[0]).step("copy-directories", new Serializable[0]).step("start-remaining-nodes", new Serializable[]{productDisplayName}).step("cluster-monitoring", new Serializable[]{this.getWebContext() + "/admin/clustering"}).step("uat", new Serializable[0]).startNewSubSection("tip", new Serializable[0]);
        return builder.build();
    }

    @VisibleForTesting
    protected PreUpgradeInfoDto.Version.UpgradePathSection createUpgradeUsingZduInTestSection(VersionUpgradeInfo versionUpgradeInfo) {
        String productDisplayName = this.supportApplicationInfo.getApplicationName();
        AbstractUpgradePathSectionFactory.SectionBuilder builder = new AbstractUpgradePathSectionFactory.SectionBuilder(this, "3b", AnalyticsKey.TEST_UPGRADE_ZDU, "zdu-upgrade-in-test-env", new Serializable[]{productDisplayName}).step("create-staging-env", new Serializable[]{RendererUtils.renderLink(versionUpgradeInfo.getTargetVersion().getStagingEnvironmentInstructionsUrl(), this.i18n.getText("stp.pup.upgrade-path-bb-cluster.upgrade-in-test-env.staging-env-link"))}).step(this.hasApps(), "check-app-compatibility", new Serializable[]{this.getWebContext() + "/plugins/servlet/upm/check?source=manage", productDisplayName}).step(versionUpgradeInfo.isInstallerAvailable(), "download-product", new Serializable[]{productDisplayName}).step(!versionUpgradeInfo.isInstallerAvailable(), "download-product-without-installer", new Serializable[]{productDisplayName}).step("backup-your-data", new Serializable[0]).step("upgrade-mode", new Serializable[]{this.getWebContext() + "/plugins/servlet/zdu"});
        builder.startNewSubSection("zdu-first-node-in-test", new Serializable[0]).step("disconnect-from-load-balancer", new Serializable[]{ZDU_UPGRADE_INFO_URL}).step("stop-first-node", new Serializable[]{productDisplayName, SHUTDOWN_INFO_URL}).step(versionUpgradeInfo.isInstallerAvailable(), "run-installer-or-upgrade-manually", new Serializable[0]).step(!versionUpgradeInfo.isInstallerAvailable(), "upgrade-manually", new Serializable[0]).step("apply-modifications", new Serializable[0]).step("start-application", new Serializable[]{productDisplayName}).step("reconnect-to-load-balancer", new Serializable[]{productDisplayName}).step("cluster-monitoring", new Serializable[]{this.getWebContext() + "/plugins/servlet/zdu"});
        builder.startNewSubSection("zdu-remaining-nodes-in-test", new Serializable[0]).step("repeat-process", new Serializable[0]).step("finalize-upgrade", new Serializable[]{this.getWebContext() + "/plugins/servlet/zdu"}).step(this.hasApps(), "update-your-apps", new Serializable[]{this.getWebContext() + "/plugins/servlet/upm"}).step("uat", new Serializable[0]).startNewSubSection("tip", new Serializable[0]);
        return builder.build();
    }

    @VisibleForTesting
    protected PreUpgradeInfoDto.Version.UpgradePathSection createUpgradeInProdSection(VersionUpgradeInfo versionUpgradeInfo, boolean isZduAvailable) {
        String productDisplayName = this.supportApplicationInfo.getApplicationName();
        AbstractUpgradePathSectionFactory.SectionBuilder builder = new AbstractUpgradePathSectionFactory.SectionBuilder(this, isZduAvailable ? "4a" : "4", AnalyticsKey.PRODUCTION_UPGRADE, "upgrade-in-prod", new Serializable[]{productDisplayName}).descriptionArgs(productDisplayName).step("schedule-downtime", new Serializable[0]).step(this.hasApps(), "check-app-compatibility", new Serializable[]{this.getWebContext() + "/plugins/servlet/upm/check?source=manage", productDisplayName}).step(versionUpgradeInfo.isInstallerAvailable(), "download-product", new Serializable[]{productDisplayName}).step(!versionUpgradeInfo.isInstallerAvailable(), "download-product-without-installer", new Serializable[]{productDisplayName}).step("stop-nodes", new Serializable[]{productDisplayName}).step("backup-your-data", new Serializable[0]);
        builder.startNewSubSection("first-node-in-prod", new Serializable[0]).step(versionUpgradeInfo.isInstallerAvailable(), "run-installer-or-upgrade-manually", new Serializable[0]).step(!versionUpgradeInfo.isInstallerAvailable(), "upgrade-manually", new Serializable[0]).step("apply-modifications", new Serializable[0]).step("start-application", new Serializable[]{productDisplayName}).step(this.hasApps(), "update-your-apps", new Serializable[]{this.getWebContext() + "/plugins/servlet/upm"}).step("stop-after-update", new Serializable[]{productDisplayName});
        builder.startNewSubSection("remaining-nodes-in-prod", new Serializable[0]).step("copy-directories", new Serializable[0]).step("start-remaining-nodes", new Serializable[]{productDisplayName}).step("cluster-monitoring", new Serializable[]{this.getWebContext() + "/admin/clustering"}).step("uat", new Serializable[0]);
        return builder.build();
    }

    @VisibleForTesting
    protected PreUpgradeInfoDto.Version.UpgradePathSection createUpgradeUsingZduInProdSection(VersionUpgradeInfo versionUpgradeInfo) {
        String productDisplayName = this.supportApplicationInfo.getApplicationName();
        AbstractUpgradePathSectionFactory.SectionBuilder builder = new AbstractUpgradePathSectionFactory.SectionBuilder(this, "4b", AnalyticsKey.PRODUCTION_UPGRADE_ZDU, "zdu-upgrade-in-prod", new Serializable[]{productDisplayName}).descriptionArgs(productDisplayName).step(this.hasApps(), "check-app-compatibility", new Serializable[]{this.getWebContext() + "/plugins/servlet/upm/check?source=manage", productDisplayName}).step(versionUpgradeInfo.isInstallerAvailable(), "download-product", new Serializable[]{productDisplayName}).step(!versionUpgradeInfo.isInstallerAvailable(), "download-product-without-installer", new Serializable[]{productDisplayName}).step("backup-your-data", new Serializable[0]).step("upgrade-mode", new Serializable[]{this.getWebContext() + "/plugins/servlet/zdu"});
        builder.startNewSubSection("zdu-first-node-in-prod", new Serializable[0]).step("disconnect-from-load-balancer", new Serializable[]{ZDU_UPGRADE_INFO_URL}).step("stop-first-node", new Serializable[]{productDisplayName, SHUTDOWN_INFO_URL}).step(versionUpgradeInfo.isInstallerAvailable(), "run-installer-or-upgrade-manually", new Serializable[0]).step(!versionUpgradeInfo.isInstallerAvailable(), "upgrade-manually", new Serializable[0]).step("apply-modifications", new Serializable[0]).step("start-application", new Serializable[]{productDisplayName}).step("reconnect-to-load-balancer", new Serializable[]{productDisplayName}).step("cluster-monitoring", new Serializable[]{this.getWebContext() + "/plugins/servlet/zdu"});
        builder.startNewSubSection("zdu-remaining-nodes-in-prod", new Serializable[0]).step("repeat-process", new Serializable[0]).step("finalize-upgrade", new Serializable[]{this.getWebContext() + "/plugins/servlet/zdu"}).step(this.hasApps(), "update-your-apps", new Serializable[]{this.getWebContext() + "/plugins/servlet/upm"}).step("uat", new Serializable[0]);
        return builder.build();
    }

    protected PreUpgradeInfoDto.Version.UpgradePathSection createPostUpgradeSection() {
        String productDisplayName = this.supportApplicationInfo.getApplicationName();
        return new AbstractUpgradePathSectionFactory.SectionBuilder(this, "5", AnalyticsKey.POST_UPGRADE, "post-upgrade", new Serializable[0]).descriptionArgs(productDisplayName).build();
    }
}

