/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.preupgrade;

import com.atlassian.bitbucket.util.Version;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.healthcheck.model.DbType;
import com.atlassian.troubleshooting.preupgrade.AbstractUpgradePathSectionFactory;
import com.atlassian.troubleshooting.preupgrade.AnalyticsKey;
import com.atlassian.troubleshooting.preupgrade.BitbucketPupPlatformAccessor;
import com.atlassian.troubleshooting.preupgrade.VersionUpgradeInfo;
import com.atlassian.troubleshooting.preupgrade.model.MicroservicePreUpgradeDataDTO;
import com.atlassian.troubleshooting.preupgrade.model.PreUpgradeInfoDto;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.atlassian.troubleshooting.util.RendererUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BitbucketNonClusteredUpgradePathSectionFactory
extends AbstractUpgradePathSectionFactory<BitbucketPupPlatformAccessor> {
    @Autowired
    public BitbucketNonClusteredUpgradePathSectionFactory(I18nResolver i18n, SupportApplicationInfo supportApplicationInfo, BitbucketPupPlatformAccessor pupPlatformAccessor, @ComponentImport PluginMetadataManager pluginMetadataManager, @ComponentImport PluginAccessor pluginAccessor) {
        super(i18n, supportApplicationInfo, pupPlatformAccessor, pluginMetadataManager, pluginAccessor, "bitbucket", false, "upgrade-path-bb", "https://docs.atlassian.com/bitbucketserver/docs-0%s%s/%s");
    }

    @Override
    public List<PreUpgradeInfoDto.Version.UpgradePathSection> getSections(VersionUpgradeInfo versionUpgradeInfo, boolean isZduAvailable) {
        return ImmutableList.of((Object)this.createChooseAnUpgradeMethodSection(versionUpgradeInfo), (Object)this.createUpgradeInATestEnvironmentSection(versionUpgradeInfo), (Object)this.createUpgradeInProdSection(versionUpgradeInfo), (Object)this.createPostUpgradeSection());
    }

    @VisibleForTesting
    protected PreUpgradeInfoDto.Version.UpgradePathSection createChooseAnUpgradeMethodSection(VersionUpgradeInfo versionUpgradeInfo) {
        return new AbstractUpgradePathSectionFactory.SectionBuilder(this, "2", AnalyticsKey.UPGRADE_METHOD, "choose-upgrade-method", new Serializable[0]).descriptionArgs(this.supportApplicationInfo.getApplicationName(), versionUpgradeInfo.getTargetVersion().getUpgradeInstructionsUrl()).build();
    }

    @VisibleForTesting
    protected PreUpgradeInfoDto.Version.UpgradePathSection createUpgradeInATestEnvironmentSection(VersionUpgradeInfo versionUpgradeInfo) {
        String productDisplayName = this.supportApplicationInfo.getApplicationName();
        return new AbstractUpgradePathSectionFactory.SectionBuilder(this, "3", AnalyticsKey.TEST_UPGRADE, "upgrade-in-test-env", new Serializable[]{productDisplayName}).descriptionArgs(productDisplayName).step("create-staging-env", new Serializable[]{RendererUtils.renderLink(versionUpgradeInfo.getTargetVersion().getStagingEnvironmentInstructionsUrl(), this.i18n.getText("stp.pup.upgrade-path-bb.upgrade-in-test-env.staging-env-link"))}).step("check-app-compatibility", new Serializable[]{this.getWebContext() + "/plugins/servlet/upm/check?source=manage", productDisplayName}).step(versionUpgradeInfo.isInstallerAvailable(), "download-product", new Serializable[]{productDisplayName}).step(!versionUpgradeInfo.isInstallerAvailable(), "download-product-without-installer", new Serializable[]{productDisplayName}).step("stop", new Serializable[]{productDisplayName}).step("backup-your-data", new Serializable[0]).step(versionUpgradeInfo.isInstallerAvailable() && versionUpgradeInfo.getLocalInstanceInfo().isWindows(), "run-installer-or-upgrade-manually-windows", new Serializable[]{productDisplayName}).step(versionUpgradeInfo.isInstallerAvailable() && !versionUpgradeInfo.getLocalInstanceInfo().isWindows(), "run-installer-or-upgrade-manually-linux", new Serializable[0]).step(!versionUpgradeInfo.isInstallerAvailable() && versionUpgradeInfo.getLocalInstanceInfo().isWindows(), "upgrade-manually-windows", new Serializable[]{productDisplayName}).step(!versionUpgradeInfo.isInstallerAvailable() && !versionUpgradeInfo.getLocalInstanceInfo().isWindows(), "upgrade-manually-linux", new Serializable[0]).step(versionUpgradeInfo.getLocalInstanceInfo().isWindows(), "apply-modifications-windows", new Serializable[0]).step(!versionUpgradeInfo.getLocalInstanceInfo().isWindows(), "apply-modifications-linux", new Serializable[0]).step(this.isIncompatibleH2Upgrade(versionUpgradeInfo.getTargetVersion()), "migrate-h2-db-file", new Serializable[]{"https://confluence.atlassian.com/pages/viewpage.action?pageId=1107633407"}).step("start-application", new Serializable[]{productDisplayName}).step(this.hasApps(), "update-your-apps", new Serializable[]{this.getWebContext() + "/plugins/servlet/upm"}).step("uat", new Serializable[0]).addSuffix(this.i18n.getText("stp.pup.test.upgrade.tip")).build();
    }

    @VisibleForTesting
    protected PreUpgradeInfoDto.Version.UpgradePathSection createUpgradeInProdSection(VersionUpgradeInfo versionUpgradeInfo) {
        String productDisplayName = this.supportApplicationInfo.getApplicationName();
        return new AbstractUpgradePathSectionFactory.SectionBuilder(this, "4", AnalyticsKey.PRODUCTION_UPGRADE, "upgrade-in-prod", new Serializable[]{productDisplayName}).step("schedule-downtime", new Serializable[0]).step("check-app-compatibility", new Serializable[]{this.getWebContext() + "/plugins/servlet/upm/check?source=manage", productDisplayName}).step(versionUpgradeInfo.isInstallerAvailable(), "download-product", new Serializable[]{productDisplayName}).step(!versionUpgradeInfo.isInstallerAvailable(), "download-product-without-installer", new Serializable[]{productDisplayName}).step("stop", new Serializable[]{productDisplayName}).step("backup-your-data", new Serializable[0]).step(versionUpgradeInfo.isInstallerAvailable() && versionUpgradeInfo.getLocalInstanceInfo().isWindows(), "run-installer-or-upgrade-manually-windows", new Serializable[]{productDisplayName}).step(versionUpgradeInfo.isInstallerAvailable() && !versionUpgradeInfo.getLocalInstanceInfo().isWindows(), "run-installer-or-upgrade-manually-linux", new Serializable[0]).step(!versionUpgradeInfo.isInstallerAvailable() && versionUpgradeInfo.getLocalInstanceInfo().isWindows(), "upgrade-manually-windows", new Serializable[]{productDisplayName}).step(!versionUpgradeInfo.isInstallerAvailable() && !versionUpgradeInfo.getLocalInstanceInfo().isWindows(), "upgrade-manually-linux", new Serializable[0]).step(versionUpgradeInfo.getLocalInstanceInfo().isWindows(), "apply-modifications-windows", new Serializable[0]).step(!versionUpgradeInfo.getLocalInstanceInfo().isWindows(), "apply-modifications-linux", new Serializable[0]).step(this.isIncompatibleH2Upgrade(versionUpgradeInfo.getTargetVersion()), "migrate-h2-db-file", new Serializable[]{"https://confluence.atlassian.com/pages/viewpage.action?pageId=1107633407"}).step("start-application", new Serializable[]{productDisplayName}).step(this.hasApps(), "update-your-apps", new Serializable[]{this.getWebContext() + "/plugins/servlet/upm"}).step("uat", new Serializable[0]).build();
    }

    protected PreUpgradeInfoDto.Version.UpgradePathSection createPostUpgradeSection() {
        String productDisplayName = this.supportApplicationInfo.getApplicationName();
        return new AbstractUpgradePathSectionFactory.SectionBuilder(this, "5", AnalyticsKey.POST_UPGRADE, "post-upgrade", new Serializable[0]).descriptionArgs(productDisplayName).build();
    }

    private boolean isIncompatibleH2Upgrade(MicroservicePreUpgradeDataDTO.Version targetVersion) {
        return this.isUpgradingFromPre80Version() && this.isUpgradingTo80PlusVersion(targetVersion) && this.isUsingH2Db() != false;
    }

    private boolean isUpgradingFromPre80Version() {
        return new Version(this.supportApplicationInfo.getApplicationVersion()).getMajor() < 8;
    }

    private boolean isUpgradingTo80PlusVersion(MicroservicePreUpgradeDataDTO.Version targetVersion) {
        return targetVersion.getVersion().getMajor() >= 8;
    }

    private Boolean isUsingH2Db() {
        return ((BitbucketPupPlatformAccessor)this.pupPlatformAccessor).getCurrentDbPlatform().filter(dbPlatform -> dbPlatform.getDbType() == DbType.h2).isPresent();
    }
}

