/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.preupgrade;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.healthcheck.model.SearchDistribution;
import com.atlassian.troubleshooting.preupgrade.AnalyticsKey;
import com.atlassian.troubleshooting.preupgrade.BitbucketPupPlatformAccessor;
import com.atlassian.troubleshooting.preupgrade.SearchServer;
import com.atlassian.troubleshooting.preupgrade.accessors.LicenseCompatibilityChecker;
import com.atlassian.troubleshooting.preupgrade.accessors.PupEnvironmentAccessor;
import com.atlassian.troubleshooting.preupgrade.checks.AbstractPlatformsChecker;
import com.atlassian.troubleshooting.preupgrade.model.MicroservicePreUpgradeDataDTO;
import com.atlassian.troubleshooting.preupgrade.model.PreUpgradeInfoDto;
import com.atlassian.troubleshooting.util.RendererUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BitbucketPlatformsChecker
extends AbstractPlatformsChecker {
    private final BitbucketPupPlatformAccessor pupPlatformAccessor;
    private final I18nResolver i18n;

    @Autowired
    public BitbucketPlatformsChecker(@ComponentImport I18nResolver i18n, PupEnvironmentAccessor pupEnvironmentAccessor, BitbucketPupPlatformAccessor pupPlatformAccessor, LicenseCompatibilityChecker licenseCompatibilityChecker) {
        super(i18n, pupEnvironmentAccessor, pupPlatformAccessor, licenseCompatibilityChecker);
        this.pupPlatformAccessor = pupPlatformAccessor;
        this.i18n = i18n;
    }

    @Override
    public List<PreUpgradeInfoDto.Version.SupportedPlatformComponentStatus> getAllPlatformStatuses(MicroservicePreUpgradeDataDTO.Version productVersion, MicroservicePreUpgradeDataDTO.SupportedPlatform platform) {
        ArrayList<PreUpgradeInfoDto.Version.SupportedPlatformComponentStatus> statuses = new ArrayList<PreUpgradeInfoDto.Version.SupportedPlatformComponentStatus>(super.getAllPlatformStatuses(productVersion, platform));
        statuses.add(this.calculateGitStatus(platform));
        statuses.add(this.calculateOperatingSystemStatus(platform));
        statuses.add(this.calculateSearchStatus(platform));
        return statuses;
    }

    @VisibleForTesting
    PreUpgradeInfoDto.Version.SupportedPlatformComponentStatus calculateGitStatus(MicroservicePreUpgradeDataDTO.SupportedPlatform platform) {
        String currentGitVersion = this.stripBugfix(this.pupPlatformAccessor.getGitVersion());
        return platform.getGit().stream().filter(currentGitVersion::equals).findFirst().map(supportedGitVersion -> this.success("stp.pup.git.version.is.supported", new Serializable[]{currentGitVersion})).orElse(this.warning(AnalyticsKey.UNSUPPORTED_GIT, "stp.pup.git.version.is.not.supported", new Serializable[]{RendererUtils.renderLink(platform.getDocUrl(), this.i18n.getText("stp.pup.default.help.link.title"))}));
    }

    @VisibleForTesting
    PreUpgradeInfoDto.Version.SupportedPlatformComponentStatus calculateOperatingSystemStatus(MicroservicePreUpgradeDataDTO.SupportedPlatform platform) {
        return platform.getVersion().major >= 8 && this.pupPlatformAccessor.isWindows() ? this.warning(AnalyticsKey.UNSUPPORTED_OPERATING_SYSTEM, "stp.pup.operating.system.is.not.supported", new Serializable[]{RendererUtils.renderLink(platform.getDocUrl(), this.i18n.getText("stp.pup.default.help.link.title"))}) : this.success("stp.pup.operating.system.is.supported", new Serializable[0]);
    }

    @VisibleForTesting
    PreUpgradeInfoDto.Version.SupportedPlatformComponentStatus calculateSearchStatus(MicroservicePreUpgradeDataDTO.SupportedPlatform platform) {
        SearchServer currentSearchServer = this.pupPlatformAccessor.getSearchServer().orElse(null);
        if (currentSearchServer == null) {
            return this.warning(AnalyticsKey.UNSUPPORTED_SEARCH, "stp.pup.search.not.configured", new Serializable[]{RendererUtils.renderLink(platform.getDocUrl(), this.i18n.getText("stp.pup.default.help.link.title"))});
        }
        SearchDistribution searchDistribution = currentSearchServer.getSearchDistribution();
        List<String> supportedSearchVersions = platform.getSearches().get((Object)searchDistribution);
        String currentSearchVersion = this.stripBugfix(currentSearchServer.getSearchVersion());
        if (supportedSearchVersions == null) {
            return this.warning(AnalyticsKey.UNSUPPORTED_SEARCH, "stp.pup.search.version.is.not.supported", new Serializable[]{RendererUtils.renderLink(platform.getDocUrl(), this.i18n.getText("stp.pup.default.help.link.title"))});
        }
        return supportedSearchVersions.stream().filter(currentSearchVersion::equals).findFirst().map(supportedSearchVersion -> this.success("stp.pup.search.version.is.supported", new Serializable[]{searchDistribution.getLabel()})).orElse(this.warning(AnalyticsKey.UNSUPPORTED_SEARCH, "stp.pup.search.version.is.not.supported", new Serializable[]{RendererUtils.renderLink(platform.getDocUrl(), this.i18n.getText("stp.pup.default.help.link.title"))}));
    }

    private String stripBugfix(String version) {
        String[] parts = version.split("\\.");
        if (parts.length > 1) {
            return parts[0] + "." + parts[1];
        }
        return version;
    }
}

