/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.preupgrade;

import com.atlassian.troubleshooting.healthcheck.model.SearchDistribution;
import com.atlassian.troubleshooting.preupgrade.SearchServer;
import com.atlassian.troubleshooting.preupgrade.SearchServerFactory;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class DefaultSearchServerFactory
implements SearchServerFactory {
    @Override
    public SearchServer create(SearchDistribution searchDistribution, String searchVersion) {
        return new SearchServerImpl(searchDistribution, searchVersion);
    }

    static class SearchServerImpl
    implements SearchServer {
        private final SearchDistribution searchDistribution;
        private final String searchVersion;

        SearchServerImpl(SearchDistribution searchDistribution, String searchVersion) {
            this.searchDistribution = searchDistribution;
            this.searchVersion = searchVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchServerImpl that = (SearchServerImpl)o;
            return this.searchDistribution == that.searchDistribution && this.searchVersion.equals(that.searchVersion);
        }

        @Override
        public SearchDistribution getSearchDistribution() {
            return this.searchDistribution;
        }

        @Override
        public String getSearchVersion() {
            return this.searchVersion;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.searchDistribution, this.searchVersion});
        }

        public String toString() {
            return "SearchServerImpl{searchDistribution=" + String.valueOf((Object)this.searchDistribution) + ", searchVersion='" + this.searchVersion + "'}";
        }
    }
}

