/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.preupgrade;

import com.atlassian.troubleshooting.preupgrade.LocalInstanceInfo;
import com.atlassian.troubleshooting.preupgrade.accessors.PupEnvironmentAccessor;
import com.atlassian.troubleshooting.preupgrade.model.MicroservicePreUpgradeDataDTO;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class VersionUpgradeInfo {
    private final LocalInstanceInfo localInstanceInfo;
    private final MicroservicePreUpgradeDataDTO.Version targetVersion;
    private final String installer;
    private final String archive;
    private final String note;

    public VersionUpgradeInfo(LocalInstanceInfo localInstanceInfo, MicroservicePreUpgradeDataDTO.Version targetVersion) {
        this.localInstanceInfo = localInstanceInfo;
        this.targetVersion = targetVersion;
        this.archive = this.findArchive(localInstanceInfo.getSubProduct(), localInstanceInfo.getOperatingSystem(), targetVersion.getLinuxArchiveDistribution(), targetVersion.getWindowsArchiveDistribution());
        this.installer = this.findInstaller(localInstanceInfo.getSubProduct(), localInstanceInfo.getPlatform(), localInstanceInfo.getOperatingSystem(), targetVersion.getLinuxInstallerDistribution(), targetVersion.getWindowsInstallerDistribution());
        this.note = this.findNote(localInstanceInfo.getSubProduct(), targetVersion.getReleaseNotes());
    }

    public LocalInstanceInfo getLocalInstanceInfo() {
        return this.localInstanceInfo;
    }

    public MicroservicePreUpgradeDataDTO.Version getTargetVersion() {
        return this.targetVersion;
    }

    public String getInstaller() {
        return this.installer;
    }

    public String getArchive() {
        return this.archive;
    }

    public String getNote() {
        return this.note;
    }

    public boolean isInstallerAvailable() {
        return this.installer != null;
    }

    private String findInstaller(MicroservicePreUpgradeDataDTO.Version.SubProduct subProduct, MicroservicePreUpgradeDataDTO.Version.Platform platform, PupEnvironmentAccessor.OperatingSystem operatingSystem, List<MicroservicePreUpgradeDataDTO.Version.Installer> linuxInstallers, List<MicroservicePreUpgradeDataDTO.Version.Installer> windowsInstallers) {
        return this.find(operatingSystem, windowsInstallers, linuxInstallers, installer -> installer.platform == platform && installer.subProduct == subProduct, installer -> installer.link);
    }

    private String findArchive(MicroservicePreUpgradeDataDTO.Version.SubProduct subProduct, PupEnvironmentAccessor.OperatingSystem operatingSystem, List<MicroservicePreUpgradeDataDTO.Version.Archive> linuxInstallers, List<MicroservicePreUpgradeDataDTO.Version.Archive> windowsInstallers) {
        return this.find(operatingSystem, windowsInstallers, linuxInstallers, archive -> archive.subProduct == subProduct, archive -> archive.link);
    }

    private <T> String find(PupEnvironmentAccessor.OperatingSystem operatingSystem, List<T> windows, List<T> linux, Predicate<T> filter, Function<T, String> extractor) {
        return (operatingSystem == PupEnvironmentAccessor.OperatingSystem.WINDOWS ? windows : linux).stream().filter(filter).findFirst().map(extractor).orElse(null);
    }

    private String findNote(MicroservicePreUpgradeDataDTO.Version.SubProduct subProduct, List<MicroservicePreUpgradeDataDTO.Version.Note> notes) {
        return notes.stream().filter(n -> n.subProduct == subProduct).findFirst().map(n -> n.link).orElse(null);
    }
}

