/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.preupgrade.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.troubleshooting.preupgrade.PreUpgradePlanningManager;
import com.atlassian.troubleshooting.stp.security.PermissionValidationService;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@Path(value="pre-upgrade")
@Produces(value={"application/json"})
@ParametersAreNonnullByDefault
public class PreUpgradePlanningResource {
    private final PreUpgradePlanningManager preUpgradePlanningManager;
    private final PermissionValidationService permissionValidationService;

    @Inject
    public PreUpgradePlanningResource(PreUpgradePlanningManager preUpgradePlanningManager, PermissionValidationService permissionValidationService) {
        this.preUpgradePlanningManager = Objects.requireNonNull(preUpgradePlanningManager);
        this.permissionValidationService = Objects.requireNonNull(permissionValidationService);
    }

    @GET
    @Path(value="info")
    @Nonnull
    public Response getSupportedPlatformInfo(@QueryParam(value="zdu") boolean zduRecommendation) {
        this.permissionValidationService.validateIsSysadmin();
        return this.preUpgradePlanningManager.getPreUpgradeInfo(zduRecommendation).map(info -> Response.ok((Object)info).build()).orElse(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"No data available").build());
    }
}

