/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp;

import com.atlassian.troubleshooting.api.PluginInfo;
import com.atlassian.troubleshooting.api.WebResourcesService;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceManager;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultWebResourcesService
implements WebResourcesService {
    private final WebResourceManager webResourceManager;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final PluginInfo pluginInfo;

    @Autowired
    public DefaultWebResourcesService(WebResourceManager webResourceManager, WebResourceUrlProvider webResourceUrlProvider, PluginInfo pluginInfo) {
        this.webResourceManager = webResourceManager;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.pluginInfo = pluginInfo;
    }

    @Override
    public void requireResourcesForContext(String context) {
        this.webResourceManager.requireResourcesForContext(context);
    }

    @Override
    public void requireResource(String webResKey) {
        this.webResourceManager.requireResource(this.pluginInfo.getPluginKey() + ":" + webResKey);
    }

    @Override
    public String getStaticPluginResource(String webResKey, String resourceName) {
        return this.webResourceUrlProvider.getStaticPluginResourceUrl(this.pluginInfo.getPluginKey() + ":" + webResKey, resourceName, UrlMode.AUTO);
    }
}

