/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.hercules;

import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

public class HerculesDateTimeUtils {
    @VisibleForTesting
    public static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ofPattern("d MMMM uuuu h:mma z");

    public static String getTimeInRelativeFormat(long logTimestamp) {
        ZonedDateTime logDateTime = Instant.ofEpochMilli(logTimestamp).atZone(ZoneId.systemDefault());
        ZonedDateTime nowDateTime = Instant.now().atZone(ZoneId.systemDefault());
        if (nowDateTime.isEqual(logDateTime) || nowDateTime.isAfter(logDateTime)) {
            return HerculesDateTimeUtils.convertToRelativeFormat(logDateTime, nowDateTime);
        }
        return DEFAULT_FORMATTER.format(logDateTime);
    }

    private static String convertToRelativeFormat(ZonedDateTime logDateTime, ZonedDateTime nowDateTime) {
        ZonedDateTime nowDateWithTimeAtStartOfDay;
        long secondsAgo = Duration.between(logDateTime, nowDateTime).getSeconds();
        if (secondsAgo < 60L) {
            return "Just now";
        }
        long minutesAgo = secondsAgo / 60L;
        if (minutesAgo < 60L) {
            if (minutesAgo == 1L) {
                return "1 minute ago";
            }
            return minutesAgo + " minutes ago";
        }
        long hoursAgo = minutesAgo / 60L;
        if (hoursAgo < 24L) {
            if (hoursAgo == 1L) {
                return "1 hour ago";
            }
            return hoursAgo + " hours ago";
        }
        ZonedDateTime logDateWithTimeAtStartOfDay = logDateTime.truncatedTo(ChronoUnit.DAYS);
        long daysAgo = ChronoUnit.DAYS.between(logDateWithTimeAtStartOfDay, nowDateWithTimeAtStartOfDay = nowDateTime.truncatedTo(ChronoUnit.DAYS));
        if (daysAgo < 7L) {
            if (daysAgo == 1L) {
                return "1 day ago";
            }
            return daysAgo + " days ago";
        }
        long weeksAgo = ChronoUnit.WEEKS.between(logDateWithTimeAtStartOfDay, nowDateWithTimeAtStartOfDay);
        if (nowDateWithTimeAtStartOfDay.minusMonths(1L).isBefore(logDateWithTimeAtStartOfDay)) {
            if (weeksAgo == 1L) {
                return "1 week ago";
            }
            return weeksAgo + " weeks ago";
        }
        long monthsAgo = ChronoUnit.MONTHS.between(logDateWithTimeAtStartOfDay, nowDateWithTimeAtStartOfDay);
        if (monthsAgo < 12L) {
            if (monthsAgo == 1L) {
                return "1 month ago";
            }
            return monthsAgo + " months ago";
        }
        long yearsAgo = ChronoUnit.YEARS.between(logDateWithTimeAtStartOfDay, nowDateWithTimeAtStartOfDay);
        if (yearsAgo == 1L) {
            return "1 year ago";
        }
        return yearsAgo + " years ago";
    }
}

