/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.properties;

import com.atlassian.troubleshooting.spi.SupportDataBuilderContext;
import com.atlassian.troubleshooting.spi.SupportDataDetail;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Map;

public class DefaultSupportDataBuilderContext
implements SupportDataBuilderContext {
    private final SupportDataDetail detail;
    private final Date start;
    private final Map<String, Object> properties;

    public DefaultSupportDataBuilderContext(@Nonnull SupportDataDetail detail, @Nonnull Date start) {
        this.detail = (SupportDataDetail)Preconditions.checkNotNull((Object)detail, (Object)"detail");
        this.start = (Date)Preconditions.checkNotNull((Object)start, (Object)"start");
        this.properties = Maps.newHashMap();
    }

    public DefaultSupportDataBuilderContext(@Nonnull SupportDataDetail detail) {
        this(detail, new Date());
    }

    public boolean removeProperty(String name) {
        return this.properties.remove(name) != null;
    }

    public SupportDataDetail getRequestDetail() {
        return this.detail;
    }

    public Date getStart() {
        return this.start;
    }

    public int getProperty(String name, int defaultValue) {
        Number value = (Number)this.properties.get(name);
        return value == null ? defaultValue : value.intValue();
    }

    public long getProperty(String name, long defaultValue) {
        Number value = (Number)this.properties.get(name);
        return value == null ? defaultValue : value.longValue();
    }

    public float getProperty(String name, float defaultValue) {
        Number value = (Number)this.properties.get(name);
        return value == null ? defaultValue : value.floatValue();
    }

    public double getProperty(String name, double defaultValue) {
        Number value = (Number)this.properties.get(name);
        return value == null ? defaultValue : value.doubleValue();
    }

    public boolean getProperty(String name, boolean defaultValue) {
        Boolean value = (Boolean)this.properties.get(name);
        return value == null ? defaultValue : value;
    }

    public <T> T getProperty(String name, T defaultValue) {
        Object value = this.properties.get(name);
        return (T)(value == null ? defaultValue : value);
    }

    public void setProperty(String name, int value) {
        this.properties.put(name, value);
    }

    public void setProperty(String name, long value) {
        this.properties.put(name, value);
    }

    public void setProperty(String name, float value) {
        this.properties.put(name, Float.valueOf(value));
    }

    public void setProperty(String name, double value) {
        this.properties.put(name, value);
    }

    public void setProperty(String name, boolean value) {
        this.properties.put(name, value);
    }

    public <T> void setProperty(String name, T value) {
        this.properties.put(name, value);
    }
}

