/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.salext.bundle;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.api.supportzip.BundleCategory;
import com.atlassian.troubleshooting.api.supportzip.FileSupportZipArtifact;
import com.atlassian.troubleshooting.api.supportzip.SupportZipBundle;
import com.atlassian.troubleshooting.k8s.HelmValuesFileCondition;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.atlassian.troubleshooting.stp.salext.bundle.AbstractSupportZipBundle;
import com.atlassian.troubleshooting.stp.salext.bundle.BundleManifest;
import com.atlassian.troubleshooting.stp.salext.bundle.fileset.RegexFileSet;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class HelmValuesBundle
extends AbstractSupportZipBundle {
    public static final String ZIP_INCLUDE_HELM_VALUES = "stp.zip.include.helm.values";
    public static final String ZIP_INCLUDE_HELM_VALUES_DESCRIPTION = "stp.zip.include.helm.values.description";
    public static final String HELM_VALUES_FILE_DIRECTORY = HelmValuesBundle.getFileBasePath(HelmValuesFileCondition.getHelmValueFilePath());
    public static final Pattern HELM_VALUES_FILE_PATTERN = Pattern.compile(".*\\.(yml|yaml)$");

    @Autowired
    public HelmValuesBundle(SupportApplicationInfo info, I18nResolver i18nResolver) {
        super(i18nResolver, BundleManifest.HELM_VALUES, ZIP_INCLUDE_HELM_VALUES, ZIP_INCLUDE_HELM_VALUES_DESCRIPTION);
    }

    @Override
    public BundleCategory getCategory() {
        return BundleCategory.CONFIG;
    }

    @Override
    public Collection<SupportZipBundle.Artifact> getArtifacts() {
        return new RegexFileSet.Builder().withDirectory(HELM_VALUES_FILE_DIRECTORY).withPattern(HELM_VALUES_FILE_PATTERN).build().getFiles().stream().map(f -> new FileSupportZipArtifact((File)f, "")).collect(Collectors.toList());
    }

    public static String getFileBasePath(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        Path parentPath = path.getParent();
        return parentPath != null ? parentPath.toString() : null;
    }
}

