/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.scm.git.GitObjectType;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class GitObjectInfo {
    private final String objectId;
    private final long size;
    private final GitObjectType type;

    private GitObjectInfo(Builder builder) {
        this.objectId = builder.objectId;
        this.size = builder.size;
        this.type = builder.type;
    }

    @Nonnull
    public String getObjectId() {
        return this.objectId;
    }

    public long getSize() {
        return this.size;
    }

    @Nonnull
    public GitObjectType getType() {
        return this.type;
    }

    public static class Builder
    extends BuilderSupport {
        private final String objectId;
        private final long size;
        private final GitObjectType type;

        public Builder(@Nonnull String objectId, long size, @Nonnull GitObjectType type) {
            this.objectId = Builder.requireNonBlank((String)objectId, (String)"objectId");
            this.size = size;
            this.type = Objects.requireNonNull(type, "type");
        }

        @Nonnull
        public GitObjectInfo build() {
            return new GitObjectInfo(this);
        }
    }
}

