/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.repository.Repository;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Optional;

public class GitQuarantineEnvironment {
    private final String alternateDirs;
    private final String objectDir;
    private final String quarantinePath;
    private final Repository repository;

    private GitQuarantineEnvironment(Repository repository, Map<String, String> environment) {
        this.repository = repository;
        this.alternateDirs = environment.get("GIT_ALTERNATE_OBJECT_DIRECTORIES");
        this.objectDir = environment.get("GIT_OBJECT_DIRECTORY");
        this.quarantinePath = environment.get("GIT_QUARANTINE_PATH");
    }

    @Nonnull
    public static Optional<GitQuarantineEnvironment> fromEnvironment(@Nonnull Repository repository, @Nonnull Map<String, String> environment) {
        if (environment.containsKey("GIT_QUARANTINE_PATH")) {
            return Optional.of(new GitQuarantineEnvironment(repository, environment));
        }
        return Optional.empty();
    }

    @Nonnull
    public Map<String, String> asMap() {
        return ImmutableMap.of((Object)"GIT_ALTERNATE_OBJECT_DIRECTORIES", (Object)this.alternateDirs, (Object)"GIT_OBJECT_DIRECTORY", (Object)this.objectDir, (Object)"GIT_QUARANTINE_PATH", (Object)this.quarantinePath);
    }

    @Nonnull
    public String getAlternateDirs() {
        return this.alternateDirs;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public String getObjectDir() {
        return this.objectDir;
    }

    @Nonnull
    public String getQuarantinePath() {
        return this.quarantinePath;
    }
}

