/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.concurrent.EmptyTransferableState;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.hook.HookHandler;
import com.atlassian.stash.internal.hook.HookRequest;
import com.atlassian.stash.internal.hook.HookResponse;
import com.atlassian.stash.internal.scm.git.GitQuarantineEnvironment;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GitQuarantineHelper
implements StatefulService {
    private final ThreadLocal<GitQuarantineEnvironment> threadLocal = new ThreadLocal();

    public Optional<GitQuarantineEnvironment> getEnvironment() {
        GitQuarantineEnvironment environment = this.threadLocal.get();
        if (environment == null) {
            this.threadLocal.remove();
            return Optional.empty();
        }
        return Optional.of(environment);
    }

    @Nonnull
    public TransferableState getState() {
        return this.getEnvironment().map(environment -> new TransferableState(){
            final /* synthetic */ GitQuarantineEnvironment val$environment;
            {
                this.val$environment = gitQuarantineEnvironment;
            }

            public void apply() {
                GitQuarantineHelper.this.threadLocal.set(this.val$environment);
            }

            public void remove() {
                GitQuarantineHelper.this.threadLocal.remove();
            }
        }).orElse((TransferableState)EmptyTransferableState.EMPTY);
    }

    @Nonnull
    public HookHandler maybeWrap(Repository repository, HookRequest request, HookHandler handler) {
        return GitQuarantineEnvironment.fromEnvironment(repository, request.getEnvironment()).map(environment -> new HookHandler(){
            final /* synthetic */ GitQuarantineEnvironment val$environment;
            final /* synthetic */ HookHandler val$handler;
            {
                this.val$environment = gitQuarantineEnvironment;
                this.val$handler = hookHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean handle(HookRequest hookRequest, HookResponse hookResponse) {
                GitQuarantineHelper.this.threadLocal.set(this.val$environment);
                try {
                    boolean bl = this.val$handler.handle(hookRequest, hookResponse);
                    return bl;
                }
                finally {
                    GitQuarantineHelper.this.threadLocal.remove();
                }
            }

            public boolean supports(@Nonnull HookRequest request) {
                return this.val$handler.supports(request);
            }
        }).orElse(handler);
    }

    @Nonnull
    public Runnable maybeWrap(@Nonnull Repository repository, @Nonnull Map<String, String> env, @Nonnull Runnable runnable) {
        Objects.requireNonNull(env, "env");
        Objects.requireNonNull(runnable, "runnable");
        return GitQuarantineEnvironment.fromEnvironment(repository, env).map(gitEnv -> () -> {
            this.threadLocal.set((GitQuarantineEnvironment)gitEnv);
            try {
                runnable.run();
            }
            finally {
                this.threadLocal.remove();
            }
        }).orElse(runnable);
    }
}

